/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import top.redscorpion.core.convert.CompositeConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.convert.impl.AtomicBooleanConverter;
import top.redscorpion.core.convert.impl.AtomicIntegerArrayConverter;
import top.redscorpion.core.convert.impl.AtomicLongArrayConverter;
import top.redscorpion.core.convert.impl.AtomicReferenceConverter;
import top.redscorpion.core.convert.impl.BooleanConverter;
import top.redscorpion.core.convert.impl.CalendarConverter;
import top.redscorpion.core.convert.impl.CharacterConverter;
import top.redscorpion.core.convert.impl.CharsetConverter;
import top.redscorpion.core.convert.impl.CurrencyConverter;
import top.redscorpion.core.convert.impl.DurationConverter;
import top.redscorpion.core.convert.impl.LocaleConverter;
import top.redscorpion.core.convert.impl.OptConverter;
import top.redscorpion.core.convert.impl.OptionalConverter;
import top.redscorpion.core.convert.impl.PairConverter;
import top.redscorpion.core.convert.impl.PathConverter;
import top.redscorpion.core.convert.impl.PeriodConverter;
import top.redscorpion.core.convert.impl.ReferenceConverter;
import top.redscorpion.core.convert.impl.StackTraceElementConverter;
import top.redscorpion.core.convert.impl.StringConverter;
import top.redscorpion.core.convert.impl.TemporalAccessorConverter;
import top.redscorpion.core.convert.impl.TimeZoneConverter;
import top.redscorpion.core.convert.impl.TripleConverter;
import top.redscorpion.core.convert.impl.TupleConverter;
import top.redscorpion.core.convert.impl.UriConverter;
import top.redscorpion.core.convert.impl.UrlConverter;
import top.redscorpion.core.convert.impl.UuidConverter;
import top.redscorpion.core.convert.impl.XmlGregorianCalendarConverter;
import top.redscorpion.core.convert.impl.ZoneIdConverter;
import top.redscorpion.core.lang.Opt;
import top.redscorpion.core.lang.tuple.Pair;
import top.redscorpion.core.lang.tuple.Triple;
import top.redscorpion.core.lang.tuple.Tuple;
import top.redscorpion.core.map.SafeConcurrentHashMap;
import top.redscorpion.core.util.RsType;

public class RegisterConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, Converter> defaultConverterMap;
    private volatile Map<Type, Converter> customConverterMap;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public RegisterConverter() {
        this.registerDefault();
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(RsType.getClass(type));
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter putCustom(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new SafeConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    private void registerDefault() {
        this.defaultConverterMap = new SafeConcurrentHashMap(64);
        this.defaultConverterMap.put(Character.class, new CharacterConverter());
        this.defaultConverterMap.put(Boolean.class, new BooleanConverter());
        this.defaultConverterMap.put(AtomicBoolean.class, new AtomicBooleanConverter());
        this.defaultConverterMap.put(CharSequence.class, new StringConverter());
        this.defaultConverterMap.put(String.class, new StringConverter());
        this.defaultConverterMap.put(URI.class, new UriConverter());
        this.defaultConverterMap.put(URL.class, new UrlConverter());
        this.defaultConverterMap.put(Calendar.class, new CalendarConverter());
        this.defaultConverterMap.put(XMLGregorianCalendar.class, new XmlGregorianCalendarConverter());
        this.defaultConverterMap.put(TemporalAccessor.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Instant.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalDate.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(ZonedDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(OffsetDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(OffsetTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(DayOfWeek.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Month.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(MonthDay.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Period.class, new PeriodConverter());
        this.defaultConverterMap.put(Duration.class, new DurationConverter());
        this.defaultConverterMap.put(WeakReference.class, ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put(SoftReference.class, ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put(AtomicReference.class, new AtomicReferenceConverter());
        this.defaultConverterMap.put(AtomicIntegerArray.class, new AtomicIntegerArrayConverter());
        this.defaultConverterMap.put(AtomicLongArray.class, new AtomicLongArrayConverter());
        this.defaultConverterMap.put(TimeZone.class, new TimeZoneConverter());
        this.defaultConverterMap.put(ZoneId.class, new ZoneIdConverter());
        this.defaultConverterMap.put(Locale.class, new LocaleConverter());
        this.defaultConverterMap.put(Charset.class, new CharsetConverter());
        this.defaultConverterMap.put(Path.class, new PathConverter());
        this.defaultConverterMap.put(Currency.class, new CurrencyConverter());
        this.defaultConverterMap.put(UUID.class, new UuidConverter());
        this.defaultConverterMap.put(StackTraceElement.class, new StackTraceElementConverter());
        this.defaultConverterMap.put(Optional.class, new OptionalConverter());
        this.defaultConverterMap.put(Opt.class, new OptConverter());
        this.defaultConverterMap.put(Pair.class, PairConverter.INSTANCE);
        this.defaultConverterMap.put(Triple.class, TripleConverter.INSTANCE);
        this.defaultConverterMap.put(Tuple.class, TupleConverter.INSTANCE);
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

