/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.codec.binary;

import java.nio.charset.Charset;
import top.redscorpion.core.codec.binary.Base64Decoder;
import top.redscorpion.core.util.RsByte;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsString;

public class Base64 {
    private static final Charset DEFAULT_CHARSET = RsCharset.UTF_8;

    public static String encode(CharSequence source) {
        return Base64.encode(source, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence source, Charset charset) {
        return Base64.encode(RsByte.toBytes(source, charset));
    }

    public static String encode(byte[] source) {
        if (source == null) {
            return null;
        }
        return java.util.Base64.getEncoder().encodeToString(source);
    }

    public static String decodeStr(CharSequence source) {
        return Base64.decodeStr(source, DEFAULT_CHARSET);
    }

    public static String decodeStr(CharSequence source, Charset charset) {
        return RsString.str(Base64.decode(source), charset);
    }

    public static byte[] decode(CharSequence base64) {
        return Base64.decode(RsByte.toBytes(base64, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] in) {
        return Base64Decoder.INSTANCE.decode(in);
    }

    public static boolean isTypeBase64(CharSequence base64) {
        if (base64 == null || base64.length() < 2) {
            return false;
        }
        byte[] bytes = RsByte.toUtf8Bytes(base64);
        if (bytes.length != base64.length()) {
            return false;
        }
        return Base64.isTypeBase64(bytes);
    }

    public static boolean isTypeBase64(byte[] base64Bytes) {
        if (base64Bytes == null || base64Bytes.length < 3) {
            return false;
        }
        boolean hasPadding = false;
        for (byte base64Byte : base64Bytes) {
            if (hasPadding) {
                if (61 == base64Byte) continue;
                return false;
            }
            if (61 == base64Byte) {
                hasPadding = true;
                continue;
            }
            if (Base64Decoder.INSTANCE.isBase64Code(base64Byte) || Base64.isWhiteSpace(base64Byte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

