/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import top.redscorpion.core.codec.Encoder;
import top.redscorpion.core.codec.binary.Base16Codec;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsHex;
import top.redscorpion.core.util.RsString;

public class PercentCodec
implements Encoder<byte[], byte[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char DEFAULT_SIZE = '\u0100';
    private static final char ESCAPE_CHAR = '%';
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public PercentCodec() {
        this(new BitSet(256));
    }

    public PercentCodec(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    @Override
    public byte[] encode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length * 3);
        for (int i = 0; i < bytes.length; ++i) {
            this.encodeTo(buffer, bytes[i]);
        }
        return buffer.array();
    }

    public String encode(CharSequence path, Charset charset, char ... customSafeChar) {
        if (null == charset || RsString.isEmpty(path)) {
            return RsString.str(path);
        }
        StringBuilder rewrittenPath = new StringBuilder(path.length() * 3);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i = 0; i < path.length(); ++i) {
            byte[] ba;
            char c = path.charAt(i);
            if (this.safeCharacters.get(c) || RsArray.contains(customSafeChar, c)) {
                rewrittenPath.append(c);
                continue;
            }
            if (this.encodeSpaceAsPlus && c == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                RsHex.appendHex(rewrittenPath, toEncode, false);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    private void encodeTo(ByteBuffer buffer, byte b) {
        if (this.safeCharacters.get(b)) {
            buffer.put(b);
        } else if (this.encodeSpaceAsPlus && b == 32) {
            buffer.put((byte)43);
        } else {
            buffer.put((byte)37);
            buffer.put((byte)Base16Codec.CODEC_UPPER.hexDigit(b >> 4));
            buffer.put((byte)Base16Codec.CODEC_UPPER.hexDigit(b));
        }
    }

    public static class Builder
    implements top.redscorpion.core.lang.builder.Builder<PercentCodec> {
        private static final long serialVersionUID = 1L;
        private final PercentCodec codec;

        public static Builder of(PercentCodec codec) {
            return new Builder(new PercentCodec((BitSet)codec.safeCharacters.clone()));
        }

        public static Builder of(CharSequence chars) {
            Assert.notNull(chars, "chars must not be null", new Object[0]);
            Builder builder = Builder.of(new PercentCodec());
            int length = chars.length();
            for (int i = 0; i < length; ++i) {
                builder.addSafe(chars.charAt(i));
            }
            return builder;
        }

        private Builder(PercentCodec codec) {
            this.codec = codec;
        }

        public Builder addSafe(char c) {
            this.codec.safeCharacters.set(c);
            return this;
        }

        public Builder addSafes(String chars) {
            int length = chars.length();
            for (int i = 0; i < length; ++i) {
                this.addSafe(chars.charAt(i));
            }
            return this;
        }

        public Builder removeSafe(char c) {
            this.codec.safeCharacters.clear(c);
            return this;
        }

        public Builder or(PercentCodec otherCodec) {
            this.codec.safeCharacters.or(otherCodec.safeCharacters);
            return this;
        }

        public Builder setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
            this.codec.encodeSpaceAsPlus = encodeSpaceAsPlus;
            return this;
        }

        @Override
        public PercentCodec build() {
            return this.codec;
        }
    }
}

