/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.io.stream.EmptyInputStream;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.ResponseBody;
import top.redscorpion.http.client.cookie.GlobalCookieManager;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;
import top.redscorpion.http.client.engine.jdk.JdkHttpInputStream;

public class JdkHttpResponse
implements Response,
Closeable {
    private final Charset requestCharset;
    private ResponseBody body;
    private Map<String, List<String>> headers;
    private final boolean ignoreEOFError;
    protected JdkHttpConnection httpConnection;
    protected int status;

    protected JdkHttpResponse(JdkHttpConnection httpConnection, boolean ignoreEOFError, Charset requestCharset, boolean isAsync, boolean isIgnoreBody) {
        this.httpConnection = httpConnection;
        this.ignoreEOFError = ignoreEOFError;
        this.requestCharset = requestCharset;
        this.init(isAsync, isIgnoreBody);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String header(String name) {
        List<String> headerValues = this.headers.get(name);
        if (RsArray.isNotEmpty(headerValues)) {
            return headerValues.get(0);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public Charset charset() {
        return RsObject.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    public JdkHttpResponse sync() {
        if (null != this.body) {
            this.body.sync();
        }
        this.close();
        return this;
    }

    public List<HttpCookie> getCookies() {
        return GlobalCookieManager.getCookies(this.httpConnection);
    }

    public HttpCookie getCookie(String name) {
        List<HttpCookie> cookie = this.getCookies();
        if (null != cookie) {
            for (HttpCookie httpCookie : cookie) {
                if (!httpCookie.getName().equals(name)) continue;
                return httpCookie;
            }
        }
        return null;
    }

    public String getCookieValue(String name) {
        HttpCookie cookie = this.getCookie(name);
        return null == cookie ? null : cookie.getValue();
    }

    @Override
    public InputStream bodyStream() {
        return null == this.body ? EmptyInputStream.INSTANCE : this.body.getStream();
    }

    @Override
    public ResponseBody body() {
        return this.body;
    }

    @Override
    public byte[] bodyBytes() {
        this.sync();
        return this.body().getBytes();
    }

    @Override
    public void close() {
        RsIo.closeQuietly(this.body);
        this.httpConnection.closeQuietly();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Response Headers: ").append("\r\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(this.bodyStr()).append("\r\n");
        return sb.toString();
    }

    private void init(boolean isAsync, boolean isIgnoreBody) throws HttpException {
        block5: {
            try {
                this.status = this.httpConnection.getCode();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block5;
                throw new HttpException(e);
            }
        }
        try {
            this.headers = this.httpConnection.headers();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        GlobalCookieManager.store(this.httpConnection, this.headers);
        if (!isIgnoreBody) {
            this.body = new ResponseBody(this, new JdkHttpInputStream(this), isAsync, this.ignoreEOFError);
        }
    }
}

