/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.net.url.UrlBuilder;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.cookie.GlobalCookieManager;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;
import top.redscorpion.http.client.engine.jdk.JdkHttpResponse;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.HttpStatus;
import top.redscorpion.http.meta.Method;

public class JdkClientEngine
implements ClientEngine {
    private ClientConfig config;
    private int redirectCount;

    @Override
    public JdkClientEngine init(ClientConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public Response send(Request message) {
        return this.send(message, true);
    }

    public JdkHttpResponse send(Request message, boolean isAsync) {
        JdkHttpConnection conn = this.buildConn(message);
        try {
            this.doSend(conn, message);
        }
        catch (IOException e) {
            RsIo.closeQuietly(conn);
            throw new IORuntimeException(e);
        }
        return this.sendRedirectIfPossible(conn, message, isAsync);
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
    }

    private void doSend(JdkHttpConnection conn, Request message) throws IOException {
        HttpBody body = message.handledBody();
        if (null != body) {
            body.writeClose(conn.getOutputStream());
            return;
        }
        conn.connect();
    }

    private JdkHttpConnection buildConn(Request message) {
        ClientConfig config = RsObject.defaultIfNull(this.config, ClientConfig::of);
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(message.handledUrl().toUrl(), (Proxy)config.getProxy()).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSslInfo(config.getSslInfo()).setInstanceFollowRedirects(false).setChunkedStreamingMode(message.isChunked() ? 4096 : -1).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (null == message.header(HeaderName.COOKIE)) {
            GlobalCookieManager.add(conn);
        }
        return conn;
    }

    private JdkHttpResponse sendRedirectIfPossible(JdkHttpConnection conn, Request message, boolean isAsync) {
        if (message.maxRedirectCount() > 0) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.closeQuietly();
                throw new HttpException(e);
            }
            if (code != 200 && HttpStatus.isRedirected(code)) {
                message.url(JdkClientEngine.getLocationUrl(message.handledUrl(), conn.header(HeaderName.LOCATION)));
                if (this.redirectCount < message.maxRedirectCount()) {
                    ++this.redirectCount;
                    return this.send(message, isAsync);
                }
            }
        }
        return new JdkHttpResponse(conn, true, message.charset(), isAsync, JdkClientEngine.isIgnoreResponseBody(message.method()));
    }

    private static UrlBuilder getLocationUrl(UrlBuilder parentUrl, String location) {
        UrlBuilder redirectUrl;
        if (!RsHttp.isHttp(location) && !RsHttp.isHttps(location)) {
            String query;
            List<String> split;
            if (!location.startsWith("/")) {
                location = RsString.addSuffixIfNot(parentUrl.getPathStr(), "/") + location;
            }
            if ((split = RsSplit.split(location, "?", 2, true, true)).size() == 2) {
                location = split.get(0);
                query = split.get(1);
            } else {
                query = null;
            }
            redirectUrl = UrlBuilder.of(parentUrl.getScheme(), parentUrl.getHost(), parentUrl.getPort(), location, query, null, parentUrl.getCharset());
        } else {
            redirectUrl = UrlBuilder.ofHttpWithoutEncode(location);
        }
        return redirectUrl;
    }

    private static boolean isIgnoreResponseBody(Method method) {
        return Method.HEAD == method || Method.CONNECT == method || Method.OPTIONS == method || Method.TRACE == method;
    }
}

