/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.redscorpion.core.exception.ValidateException;
import top.redscorpion.core.regex.PatternPool;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsRegular;

public class RsValidator {
    public static boolean isMatchRegex(Pattern pattern, CharSequence value) {
        return RsRegular.isMatch(pattern, value);
    }

    public static boolean isEmail(CharSequence value) {
        return RsValidator.isMatchRegex(PatternPool.EMAIL, value);
    }

    public static boolean isMobile(CharSequence value) {
        return RsValidator.isMatchRegex(PatternPool.MOBILE, value);
    }

    public static boolean isBirthday(int year, int month, int day) {
        int thisYear = RsDate.thisYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            return false;
        }
        if (month == 2) {
            return day < 29 || day == 29 && RsDate.isLeapYear(year);
        }
        return true;
    }

    public static boolean isBirthday(CharSequence value) {
        Matcher matcher = PatternPool.BIRTHDAY.matcher(value);
        if (matcher.find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return RsValidator.isBirthday(year, month, day);
        }
        return false;
    }

    public static void checkIndexLimit(int index, int size) {
        if (index > (size + 1) * 10) {
            throw new ValidateException("Index [{}] is too large for size: [{}]", index, size);
        }
    }
}

