/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.net.url.RFC3986;
import top.redscorpion.core.net.url.UrlEncoder;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsClassLoader;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsString;

public class RsUrl {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";

    public static URL url(URI uri) throws RsException {
        if (null == uri) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RsException(e);
        }
    }

    public static URL url(String url) {
        return RsUrl.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        if (null == url) {
            return null;
        }
        if (url.startsWith(CLASSPATH_URL_PREFIX)) {
            url = url.substring(CLASSPATH_URL_PREFIX.length());
            return RsClassLoader.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new RsException(e);
            }
        }
    }

    public static URL toUrlForHttp(String urlStr) {
        return RsUrl.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = UrlEncoder.encodeBlank(urlStr);
        try {
            return new URL(null, urlStr, handler);
        }
        catch (MalformedURLException e) {
            throw new RsException(e);
        }
    }

    public static URL getUrl(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RsException(e, "Error occured when get URL!", new Object[0]);
        }
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = RsUrl.toUri(url).getPath();
        }
        catch (RsException rsException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toUri(URL url) throws RsException {
        return RsUrl.toUri(url, false);
    }

    public static URI toUri(URL url, boolean isEncode) throws RsException {
        if (null == url) {
            return null;
        }
        return RsUrl.toUri(url.toString(), isEncode);
    }

    public static URI toUri(String location, boolean isEncode) throws RsException {
        if (isEncode) {
            location = RFC3986.PATH.encode(location, RsCharset.UTF_8, new char[0]);
        }
        try {
            return new URI(RsString.trim(location));
        }
        catch (URISyntaxException e) {
            throw new RsException(e);
        }
    }

    public static boolean isFileUrl(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static InputStream getStream(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long size(URL url) {
        if (RsUrl.isFileUrl(url)) {
            File file = RsFile.file(url);
            long length = file.length();
            if (length == 0L && !file.exists()) {
                throw new IORuntimeException("File not exist or size is zero!");
            }
            return length;
        }
        try {
            URLConnection con = url.openConnection();
            RsUrl.useCachesIfNecessary(con);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)con;
                httpCon.setRequestMethod("HEAD");
            }
            return con.getContentLengthLong();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }
}

