/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystem;

public class RsFileName {
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final CharSequence[] SPECIAL_SUFFIX = new CharSequence[]{"tar.bz2", "tar.Z", "tar.gz", "tar.xz"};

    public static String getName(File file) {
        return null != file ? file.getName() : null;
    }

    public static String getName(String filePath) {
        if (null == filePath) {
            return null;
        }
        int len = filePath.length();
        if (0 == len) {
            return filePath;
        }
        if (RsChar.isFileSeparator(filePath.charAt(len - 1))) {
            --len;
        }
        int begin = 0;
        for (int i = len - 1; i > -1; --i) {
            char c = filePath.charAt(i);
            if (!RsChar.isFileSeparator(c)) continue;
            begin = i + 1;
            break;
        }
        return filePath.substring(begin, len);
    }

    public static String addTempSuffix(String fileName, String suffix) {
        suffix = RsString.isBlank(suffix) ? ".temp" : RsString.addPrefixIfNot(suffix, ".");
        return fileName + suffix;
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return RsFileName.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        int secondToLastIndex = fileName.substring(0, index).lastIndexOf(".");
        String substr = fileName.substring(secondToLastIndex == -1 ? index : secondToLastIndex + 1);
        if (RsString.containsAny((CharSequence)substr, SPECIAL_SUFFIX)) {
            return substr;
        }
        String ext = fileName.substring(index + 1);
        return RsString.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("\\\\")) {
            return path;
        }
        String pathToUse = RsString.removePrefix(path, "classpath:", true);
        if (RsString.startWith((CharSequence)(pathToUse = RsString.removePrefix(pathToUse, "file:", true)), '~')) {
            pathToUse = RsSystem.getUserHomePath() + pathToUse.substring(1);
        }
        pathToUse = pathToUse.replaceAll("[/\\\\]+", "/");
        pathToUse = RsString.trimPrefix(pathToUse);
        String prefix = "";
        int prefixIndex = pathToUse.indexOf(":");
        if (prefixIndex > -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (RsString.startWith((CharSequence)prefix, '/')) {
                prefix = prefix.substring(1);
            }
            if (!prefix.contains("/")) {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            } else {
                prefix = "";
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = RsSplit.split(pathToUse, "/");
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (int i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        if (tops > 0 && RsString.isEmpty(prefix)) {
            while (tops-- > 0) {
                pathElements.add(0, "..");
            }
        }
        return prefix + RsColl.join(pathElements, "/");
    }
}

