/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.util.RsString;

public class RsDesensitize {
    public static String clear() {
        return "";
    }

    public static String firstMask(String str) {
        if (RsString.isBlank(str)) {
            return "";
        }
        return RsString.hide(str, 1, str.length());
    }

    public static String address(String address, int sensitiveSize) {
        if (RsString.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return RsString.hide(address, length - sensitiveSize, length);
    }

    public static String email(String email) {
        if (RsString.isBlank(email)) {
            return "";
        }
        int index = RsString.indexOf((CharSequence)email, '@');
        if (index <= 1) {
            return email;
        }
        return RsString.hide(email, 1, index);
    }

    public static String password(String password) {
        if (RsString.isBlank(password)) {
            return "";
        }
        return RsString.repeat('*', password.length());
    }

    public static String bankCard(String bankCardNo) {
        if (RsString.isBlank(bankCardNo)) {
            return bankCardNo;
        }
        if ((bankCardNo = RsString.cleanBlank(bankCardNo)).length() < 9) {
            return bankCardNo;
        }
        int length = bankCardNo.length();
        int endLength = length % 4 == 0 ? 4 : length % 4;
        int midLength = length - 4 - endLength;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append('*');
        }
        buf.append(' ').append(bankCardNo, length - endLength, length);
        return buf.toString();
    }

    public static String ipv4(String ipv4) {
        return RsString.subBefore((CharSequence)ipv4, '.', false) + ".*.*.*";
    }

    public static String ipv6(String ipv6) {
        return RsString.subBefore((CharSequence)ipv6, ':', false) + ":*:*:*:*:*:*:*";
    }

    public static String name(String fullName) {
        return RsDesensitize.firstMask(fullName);
    }

    public static String text(String str) {
        return RsDesensitize.text(str, 2, 2);
    }

    public static String text(String str, int front, int end) {
        if (RsString.isBlank(str)) {
            return "";
        }
        if (front >= str.length()) {
            return RsString.hide(str, 1, str.length());
        }
        if (front + end >= str.length()) {
            return RsString.hide(str, front, str.length());
        }
        if (front < 0 && end < 0) {
            return RsString.hide(str, 1, str.length());
        }
        if (front < 0 && end >= 0) {
            return RsString.hide(str, 0, str.length() - end);
        }
        if (front >= 0 && end < 0) {
            return RsString.hide(str, front, str.length());
        }
        return RsString.hide(str, front, str.length() - end);
    }

    public static String idCard(String idCard) {
        return RsDesensitize.text(idCard, 1, 2);
    }

    public static String tel(String num) {
        if (RsString.isBlank(num)) {
            return "";
        }
        return RsString.hide(num, 4, num.length() - 2);
    }

    public static String mobile(String num) {
        if (RsString.isBlank(num)) {
            return "";
        }
        return RsString.hide(num, 3, num.length() - 4);
    }
}

