/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.multipart;

import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsString;

public class UploadFileHeader {
    String formFieldName;
    String formFileName;
    String path;
    String fileName;
    boolean isFile;
    String contentType;
    String mimeType;
    String mimeSubtype;
    String contentDisposition;

    UploadFileHeader(String dataHeader) {
        this.processHeaderString(dataHeader);
    }

    public String getFileName() {
        return this.fileName;
    }

    private String getDataFieldValue(String dataHeader, String fieldName) {
        String value = null;
        String token = RsString.format("{}=\"", fieldName);
        int pos = dataHeader.indexOf(token);
        if (pos > 0) {
            int start = pos + token.length();
            int end = dataHeader.indexOf(34, start);
            if (start > 0 && end > 0) {
                value = dataHeader.substring(start, end);
            }
        }
        return value;
    }

    private String getContentType(String dataHeader) {
        String token = "Content-Type:";
        int start = dataHeader.indexOf("Content-Type:");
        if (start == -1) {
            return "";
        }
        return dataHeader.substring(start += "Content-Type:".length());
    }

    private String getContentDisposition(String dataHeader) {
        int start = dataHeader.indexOf(58) + 1;
        int end = dataHeader.indexOf(59);
        return dataHeader.substring(start, end);
    }

    private String getMimeType(String contentType) {
        int pos = contentType.indexOf(47);
        if (pos == -1) {
            return contentType;
        }
        return contentType.substring(1, pos);
    }

    private String getMimeSubtype(String contentType) {
        int start = contentType.indexOf(47);
        if (start == -1) {
            return contentType;
        }
        return contentType.substring(++start);
    }

    private void processHeaderString(String dataHeader) {
        this.isFile = dataHeader.indexOf("filename") > 0;
        this.formFieldName = this.getDataFieldValue(dataHeader, "name");
        if (this.isFile) {
            int ls;
            this.formFileName = this.getDataFieldValue(dataHeader, "filename");
            if (this.formFileName == null) {
                return;
            }
            if (this.formFileName.length() == 0) {
                this.path = "";
                this.fileName = "";
            }
            if ((ls = RsFile.lastIndexOfSeparator(this.formFileName)) == -1) {
                this.path = "";
                this.fileName = this.formFileName;
            } else {
                this.path = this.formFileName.substring(0, ls);
                this.fileName = this.formFileName.substring(ls);
            }
            if (this.fileName.length() > 0) {
                this.contentType = this.getContentType(dataHeader);
                this.mimeType = this.getMimeType(this.contentType);
                this.mimeSubtype = this.getMimeSubtype(this.contentType);
                this.contentDisposition = this.getContentDisposition(dataHeader);
            }
        }
    }
}

