/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.multipart;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import top.redscorpion.core.net.multipart.MultipartRequestInputStream;
import top.redscorpion.core.net.multipart.UploadFileHeader;
import top.redscorpion.core.net.multipart.UploadSetting;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsFileName;
import top.redscorpion.core.util.RsIo;

public class UploadFile {
    private static final String TMP_FILE_PREFIX = "rs-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private final UploadFileHeader header;
    private final UploadSetting setting;
    private long size = -1L;
    private byte[] data;
    private File tempFile;

    public UploadFile(UploadFileHeader header, UploadSetting setting) {
        this.header = header;
        this.setting = setting;
    }

    public String getFileName() {
        return this.header == null ? null : this.header.getFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processStream(MultipartRequestInputStream input) throws IOException {
        BufferedOutputStream out;
        block8: {
            long maxFileSize;
            block7: {
                boolean bl;
                if (!this.isAllowedExtension()) {
                    this.size = input.skipToBoundary();
                    return false;
                }
                this.size = 0L;
                int memoryThreshold = this.setting.memoryThreshold;
                if (memoryThreshold > 0) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(memoryThreshold);
                    long written = input.copy(baos, memoryThreshold);
                    this.data = baos.toByteArray();
                    if (written <= (long)memoryThreshold) {
                        this.size = this.data.length;
                        return true;
                    }
                }
                this.tempFile = RsFile.createTempFile(TMP_FILE_PREFIX, TMP_FILE_SUFFIX, RsFile.touch(this.setting.tmpUploadPath), false);
                out = RsFile.getOutputStream(this.tempFile);
                if (this.data != null) {
                    this.size = this.data.length;
                    out.write(this.data);
                    this.data = null;
                }
                maxFileSize = this.setting.maxFileSize;
                try {
                    if (maxFileSize != -1L) break block7;
                    this.size += input.copy(out);
                    bl = true;
                }
                catch (Throwable throwable) {
                    RsIo.closeQuietly(out);
                    throw throwable;
                }
                RsIo.closeQuietly(out);
                return bl;
            }
            this.size += input.copy(out, maxFileSize - this.size + 1L);
            if (this.size <= maxFileSize) break block8;
            this.tempFile.delete();
            this.tempFile = null;
            input.skipToBoundary();
            boolean bl = false;
            RsIo.closeQuietly(out);
            return bl;
        }
        RsIo.closeQuietly(out);
        return true;
    }

    private boolean isAllowedExtension() {
        String[] exts = this.setting.fileExts;
        boolean isAllow = this.setting.isAllowFileExts;
        if (exts == null || exts.length == 0) {
            return isAllow;
        }
        String fileNameExt = RsFileName.extName(this.getFileName());
        for (String fileExtension : this.setting.fileExts) {
            if (!fileNameExt.equalsIgnoreCase(fileExtension)) continue;
            return isAllow;
        }
        return !isAllow;
    }
}

