/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.stream;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.stream.FastByteArrayOutputStream;
import top.redscorpion.core.io.stream.ValidateObjectInputStream;
import top.redscorpion.core.util.RsIo;

public class StreamReader {
    private final InputStream in;
    private final boolean closeAfterRead;

    public static StreamReader of(InputStream in, boolean closeAfterRead) {
        return new StreamReader(in, closeAfterRead);
    }

    public StreamReader(InputStream in, boolean closeAfterRead) {
        this.in = in;
        this.closeAfterRead = closeAfterRead;
    }

    public byte[] readBytes() throws IORuntimeException {
        return this.readBytes(-1);
    }

    public byte[] readBytes(int length) throws IORuntimeException {
        InputStream in = this.in;
        if (null == in || length == 0) {
            return new byte[0];
        }
        return this.read(length).toByteArrayZeroCopyIfPossible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FastByteArrayOutputStream read(int limit) throws IORuntimeException {
        FastByteArrayOutputStream out;
        InputStream in = this.in;
        if (in instanceof FileInputStream) {
            try {
                int length = in.available();
                if (limit > 0 && limit < length) {
                    length = limit;
                }
                out = new FastByteArrayOutputStream(length);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        } else {
            out = new FastByteArrayOutputStream();
        }
        try {
            RsIo.copy(in, out, 8192, limit, null);
            if (!this.closeAfterRead) return out;
        }
        catch (Throwable throwable) {
            if (!this.closeAfterRead) throw throwable;
            RsIo.closeQuietly(in);
            throw throwable;
        }
        RsIo.closeQuietly(in);
        return out;
    }

    public <T> T readObj(Class<?> ... acceptClasses) throws IORuntimeException, RsException {
        ValidateObjectInputStream validateIn;
        InputStream in = this.in;
        if (null == in) {
            return null;
        }
        if (in instanceof ValidateObjectInputStream) {
            validateIn = (ValidateObjectInputStream)in;
            validateIn.accept(acceptClasses);
        } else {
            try {
                validateIn = new ValidateObjectInputStream(in, acceptClasses);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        try {
            return (T)validateIn.readObject();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RsException(e);
        }
    }
}

