/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.FileWrapper;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;

public class FileWriter
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileWriter of(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public File write(String content, boolean isAppend) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(isAppend);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly(writer);
                throw throwable;
            }
        }
        RsIo.closeQuietly(writer);
        return this.file;
    }

    public File append(String content) throws IORuntimeException {
        return this.write(content, true);
    }

    public BufferedWriter getWriter(boolean isAppend) throws IORuntimeException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(RsFile.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    private void checkFile() throws IORuntimeException {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new IORuntimeException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }
}

