/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format;

import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.SafeConcurrentHashMap;
import top.redscorpion.core.util.RsDate;

public class GlobalCustomFormat {
    public static final String FORMAT_SECONDS = "#sss";
    public static final String FORMAT_MILLISECONDS = "#SSS";
    private static final Map<CharSequence, Function<Date, String>> FORMATTER_MAP = new SafeConcurrentHashMap<CharSequence, Function<Date, String>>();
    private static final Map<CharSequence, Function<CharSequence, Date>> PARSER_MAP = new SafeConcurrentHashMap<CharSequence, Function<CharSequence, Date>>();

    public static void putFormatter(String format, Function<Date, String> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        FORMATTER_MAP.put(format, func);
    }

    public static void putParser(String format, Function<CharSequence, Date> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        PARSER_MAP.put(format, func);
    }

    public static boolean isCustomFormat(String format) {
        return FORMATTER_MAP.containsKey(format);
    }

    public static String format(Date date, CharSequence format) {
        Function<Date, String> func;
        if (null != FORMATTER_MAP && null != (func = FORMATTER_MAP.get(format))) {
            return func.apply(date);
        }
        return null;
    }

    public static Date parse(CharSequence dateStr, String format) {
        Function<CharSequence, Date> func;
        if (null != PARSER_MAP && null != (func = PARSER_MAP.get(format))) {
            return func.apply(dateStr);
        }
        return null;
    }

    static {
        GlobalCustomFormat.putFormatter(FORMAT_SECONDS, date -> String.valueOf(Math.floorDiv(date.getTime(), 1000L)));
        GlobalCustomFormat.putParser(FORMAT_SECONDS, dateStr -> RsDate.date(Math.multiplyExact(Long.parseLong(dateStr.toString()), 1000L)));
        GlobalCustomFormat.putFormatter(FORMAT_MILLISECONDS, date -> String.valueOf(date.getTime()));
        GlobalCustomFormat.putParser(FORMAT_MILLISECONDS, dateStr -> RsDate.date(Long.parseLong(dateStr.toString())));
    }
}

