/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.net.url.UrlBuilder;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.cookie.GlobalCookieManager;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;
import top.redscorpion.http.client.engine.jdk.JdkHttpResponse;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.HttpStatus;
import top.redscorpion.http.meta.Method;

public class JdkClientEngine
implements ClientEngine {
    private ClientConfig config;
    private JdkHttpConnection conn;
    private int redirectCount;

    @Override
    public JdkClientEngine init(ClientConfig config) {
        this.config = config;
        if (null != this.conn) {
            this.conn.disconnectQuietly();
            this.conn = null;
        }
        return this;
    }

    @Override
    public Response send(Request message) {
        return this.send(message, true);
    }

    public JdkHttpResponse send(Request message, boolean isAsync) {
        this.initConn(message);
        try {
            this.doSend(message);
        }
        catch (IOException e) {
            RsIo.closeQuietly(this);
            throw new IORuntimeException(e);
        }
        return this.sendRedirectIfPossible(message, isAsync);
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
        if (null != this.conn) {
            this.conn.disconnectQuietly();
        }
    }

    private void doSend(Request message) throws IOException {
        HttpBody body = message.body();
        if (null != body) {
            body.writeClose(this.conn.getOutputStream());
            return;
        }
        this.conn.connect();
    }

    private void initConn(Request message) {
        RsIo.closeQuietly(this);
        this.conn = this.buildConn(message);
    }

    private JdkHttpConnection buildConn(Request message) {
        ClientConfig config = RsObject.defaultIfNull(this.config, ClientConfig::of);
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(message.url().toUrl(), (Proxy)config.getProxy()).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSslInfo(config.getSslInfo()).setInstanceFollowRedirects(false).setChunkedStreamingMode(message.isChunked() ? 4096 : -1).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (null == message.header(HeaderName.COOKIE)) {
            GlobalCookieManager.add(conn);
        }
        return conn;
    }

    private JdkHttpResponse sendRedirectIfPossible(Request message, boolean isAsync) {
        JdkHttpConnection conn = this.conn;
        if (message.maxRedirectCount() > 0) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.disconnectQuietly();
                throw new HttpException(e);
            }
            if (code != 200 && HttpStatus.isRedirected(code)) {
                message.url(JdkClientEngine.getLocationUrl(message.url(), conn.header(HeaderName.LOCATION)));
                if (this.redirectCount < message.maxRedirectCount()) {
                    ++this.redirectCount;
                    return this.send(message, isAsync);
                }
            }
        }
        return new JdkHttpResponse(this.conn, true, message.charset(), isAsync, JdkClientEngine.isIgnoreResponseBody(message.method()));
    }

    private static UrlBuilder getLocationUrl(UrlBuilder parentUrl, String location) {
        UrlBuilder redirectUrl;
        if (!RsHttp.isHttp(location) && !RsHttp.isHttps(location)) {
            String query;
            List<String> split;
            if (!location.startsWith("/")) {
                location = RsString.addSuffixIfNot(parentUrl.getPathStr(), "/") + location;
            }
            if ((split = RsSplit.split(location, "?", 2, true, true)).size() == 2) {
                location = split.get(0);
                query = split.get(1);
            } else {
                query = null;
            }
            redirectUrl = UrlBuilder.of(parentUrl.getScheme(), parentUrl.getHost(), parentUrl.getPort(), location, query, null, parentUrl.getCharset());
        } else {
            redirectUrl = UrlBuilder.ofHttpWithoutEncode(location);
        }
        return redirectUrl;
    }

    private static boolean isIgnoreResponseBody(Method method) {
        return Method.HEAD == method || Method.CONNECT == method || Method.OPTIONS == method || Method.TRACE == method;
    }
}

