/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.Response;

public class HttpClient4Response
implements Response {
    private final CloseableHttpResponse rawRes;
    private final Charset requestCharset;

    public HttpClient4Response(CloseableHttpResponse rawRes, Charset requestCharset) {
        this.rawRes = rawRes;
        this.requestCharset = requestCharset;
    }

    @Override
    public int getStatus() {
        return this.rawRes.getStatusLine().getStatusCode();
    }

    @Override
    public String header(String name) {
        Header[] headers = this.rawRes.getHeaders(name);
        if (RsArray.isNotEmpty(headers)) {
            return headers[0].getValue();
        }
        return null;
    }

    @Override
    public Map<String, List<String>> headers() {
        Header[] headers = this.rawRes.getAllHeaders();
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(headers.length, 1.0f);
        for (Header header : headers) {
            List valueList = result.computeIfAbsent(header.getName(), k -> new ArrayList());
            valueList.add(header.getValue());
        }
        return result;
    }

    @Override
    public long contentLength() {
        return this.rawRes.getEntity().getContentLength();
    }

    @Override
    public Charset charset() {
        return RsObject.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        try {
            return this.rawRes.getEntity().getContent();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public String bodyStr() throws HttpException {
        try {
            return EntityUtils.toString((HttpEntity)this.rawRes.getEntity(), (Charset)this.charset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ParseException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.rawRes.close();
    }
}

