/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.cookie;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsUrl;
import top.redscorpion.http.client.cookie.ThreadLocalCookieStore;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;

public class GlobalCookieManager {
    private static CookieManager cookieManager = new CookieManager(new ThreadLocalCookieStore(), CookiePolicy.ACCEPT_ALL);

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }

    public static void setCookieManager(CookieManager customCookieManager) {
        cookieManager = customCookieManager;
    }

    public static CookieManager getCookieManager() {
        return cookieManager;
    }

    public static List<HttpCookie> getCookies(JdkHttpConnection conn) {
        return cookieManager.getCookieStore().get(GlobalCookieManager.getUri(conn));
    }

    public static void add(JdkHttpConnection conn) {
        Map<String, List<String>> cookieHeader;
        if (null == cookieManager) {
            return;
        }
        try {
            cookieHeader = cookieManager.get(GlobalCookieManager.getUri(conn), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        conn.header(cookieHeader, false);
    }

    public static void store(JdkHttpConnection conn) {
        GlobalCookieManager.store(conn, conn.headers());
    }

    public static void store(JdkHttpConnection conn, Map<String, List<String>> responseHeaders) {
        if (null == cookieManager || RsMap.isEmpty(responseHeaders)) {
            return;
        }
        try {
            cookieManager.put(GlobalCookieManager.getUri(conn), responseHeaders);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static URI getUri(JdkHttpConnection conn) {
        return RsUrl.toUri(conn.getUrl());
    }
}

