/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.body;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import top.redscorpion.core.io.resource.FileResource;
import top.redscorpion.core.io.resource.MultiFileResource;
import top.redscorpion.core.map.TableMap;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.client.body.HttpBody;

public abstract class AbstractFormBody<T extends AbstractFormBody<T>>
implements HttpBody {
    protected Map<String, Object> form;
    protected final Charset charset;

    protected AbstractFormBody(Map<String, Object> form, Charset charset) {
        this.form = form;
        this.charset = charset;
    }

    public T form(Map<String, Object> formMap) {
        if (RsMap.isNotEmpty(formMap)) {
            formMap.forEach(this::form);
        }
        return (T)this;
    }

    public T form(String name, Object value) {
        String strValue;
        if (RsString.isBlank(name)) {
            return (T)this;
        }
        if (RsObject.isNull(value)) {
            this.form.remove(name);
        }
        if (value instanceof File) {
            return this.putToForm(name, new FileResource((File)value));
        }
        if (value instanceof Path) {
            return this.putToForm(name, new FileResource((Path)value));
        }
        if (value instanceof Iterable) {
            strValue = RsColl.join((Iterable)value, ",");
        } else if (RsArray.isArray(value)) {
            Class<?> componentType = RsArray.getComponentType(value);
            if (File.class == componentType) {
                return this.putToForm(name, new MultiFileResource((File[])value));
            }
            if (Path.class == componentType) {
                return this.putToForm(name, new MultiFileResource((Path[])value));
            }
            strValue = RsArray.join(value, (CharSequence)",");
        } else {
            strValue = RsConvert.toStr(value, null);
        }
        return this.putToForm(name, strValue);
    }

    private T putToForm(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.form) {
                this.form = new TableMap<String, Object>(16);
            }
            this.form.put(name, value);
        }
        return (T)this;
    }
}

