/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.net.url.RFC3986;
import top.redscorpion.core.net.url.UrlEncoder;
import top.redscorpion.core.net.url.UrlQuery;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;

public class RsUrlQuery {
    public static String toQuery(Map<String, ?> paramMap, Charset charset) {
        return RsUrlQuery.toQuery(paramMap, charset, null);
    }

    public static String toQuery(Map<String, ?> paramMap, Charset charset, UrlQuery.EncodeMode encodeMode) {
        return UrlQuery.of(paramMap, encodeMode).build(charset);
    }

    public static String encodeQuery(String urlWithParams, Charset charset) {
        String paramPart;
        if (RsString.isBlank(urlWithParams)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = urlWithParams.indexOf(63);
        if (pathEndPos > -1) {
            urlPart = RsString.subPre(urlWithParams, pathEndPos);
            paramPart = RsString.subSuf(urlWithParams, pathEndPos + 1);
            if (RsString.isBlank(paramPart)) {
                return urlPart;
            }
        } else {
            if (!RsString.contains((CharSequence)urlWithParams, '=')) {
                return urlWithParams;
            }
            paramPart = urlWithParams;
        }
        paramPart = RsUrlQuery.normalizeQuery(paramPart, charset);
        return RsString.isBlank(urlPart) ? paramPart : urlPart + "?" + paramPart;
    }

    public static String normalizeQuery(String queryPart, Charset charset) {
        int lastIndex;
        int i;
        if (RsString.isEmpty(queryPart)) {
            return queryPart;
        }
        StringBuilder builder = new StringBuilder(queryPart.length() + 16);
        int len = queryPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = queryPart.charAt(i);
            if (c == '=') {
                if (null != name) continue;
                name = pos == i ? "" : queryPart.substring(pos, i);
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (pos != i) {
                if (null == name) {
                    name = queryPart.substring(pos, i);
                    builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=');
                } else {
                    builder.append(RFC3986.QUERY_PARAM_NAME.encode(name, charset, new char[0])).append('=').append(RFC3986.QUERY_PARAM_VALUE.encode(queryPart.substring(pos, i), charset, new char[0])).append('&');
                }
                name = null;
            }
            pos = i + 1;
        }
        if (null != name) {
            builder.append(UrlEncoder.encodeQuery(name, charset)).append('=');
        }
        if (pos != i) {
            if (null == name && pos > 0) {
                builder.append('=');
            }
            builder.append(UrlEncoder.encodeQuery(queryPart.substring(pos, i), charset));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            builder.delete(lastIndex, builder.length());
        }
        return builder.toString();
    }

    public static Map<String, List<String>> decodeQueryList(String paramsStr, Charset charset) {
        Map<CharSequence, CharSequence> queryMap = UrlQuery.of(paramsStr, charset).getQueryMap();
        if (RsMap.isEmpty(queryMap)) {
            return RsMap.empty();
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        queryMap.forEach((key, value) -> {
            List values = params.computeIfAbsent(RsString.str(key), k -> new ArrayList(1));
            values.add(RsString.str(value));
        });
        return params;
    }
}

