/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.lang.Console;
import top.redscorpion.core.util.RsBoolean;

public class RsSystem {
    public static String RS_DATE_LENIENT = "rs.date.lenient";

    public static String get(String key) {
        return RsSystem.get(key, false);
    }

    public static String getQuietly(String key) {
        return RsSystem.get(key, true);
    }

    public static String get(String name, boolean quiet) {
        String value;
        block6: {
            block5: {
                value = null;
                try {
                    value = System.getProperty(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block5;
                    Console.error("Caught a SecurityException reading the system property '{}'; the RsSystem property value will default to null.", name);
                }
            }
            if (null == value) {
                try {
                    value = System.getenv(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block6;
                    Console.error("Caught a SecurityException reading the system env '{}'; the RsSystem env value will default to null.", name);
                }
            }
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = RsSystem.get(key);
        if (value == null) {
            return defaultValue;
        }
        return RsBoolean.toBoolean(value);
    }

    public static String getUserHomePath() {
        return RsSystem.get("user.home");
    }
}

