/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.reflect.method.RsMethod;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsIter;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsNumber;
import top.redscorpion.core.util.RsSerialize;
import top.redscorpion.core.util.RsString;

public class RsObject {
    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return RsNumber.equals((Number)obj1, (Number)obj2);
        }
        if (RsArray.isArray(obj1) && RsArray.isArray(obj2)) {
            return RsArray.equals(obj1, obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean notEquals(Object obj1, Object obj2) {
        return !RsObject.equals(obj1, obj2);
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return RsString.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return RsColl.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return RsMap.isEmpty((Map)obj);
        }
        if (obj instanceof Iterable) {
            return RsIter.isEmpty((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return RsIter.isEmpty((Iterator)obj);
        }
        if (RsArray.isArray(obj)) {
            return RsArray.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !RsObject.isEmpty(obj);
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return RsObject.isNull(object) ? defaultValue : object;
    }

    public static <T> T defaultIfNull(T source, Supplier<? extends T> defaultSupplier) {
        if (RsObject.isNotNull(source)) {
            return source;
        }
        return defaultSupplier.get();
    }

    public static <T> T clone(T obj) {
        T result = RsArray.clone(obj);
        if (null != result) {
            return result;
        }
        if (obj instanceof Cloneable) {
            try {
                return RsMethod.invoke(obj, "clone", new Object[0]);
            }
            catch (RsException e) {
                if (e.getCause() instanceof IllegalAccessException) {
                    return RsObject.cloneByStream(obj);
                }
                throw e;
            }
        }
        return RsObject.cloneByStream(obj);
    }

    public static <T> T cloneByStream(T obj) {
        return RsSerialize.clone(obj);
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj instanceof Map) {
            return obj.toString();
        }
        return RsConvert.toStr(obj);
    }
}

