/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.net.Ipv4Pool;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsMacAddress;
import top.redscorpion.core.util.RsNet;

public class RsIpv4
implements Ipv4Pool {
    public static byte[] getLocalHardwareAddress() {
        return RsMacAddress.getHardwareAddress(RsIpv4.getLocalhost());
    }

    public static InetAddress getLocalhost() {
        return Singleton.get(RsIpv4.class.getName(), RsIpv4::getLocalhostDirectly);
    }

    public static InetAddress getLocalhostDirectly() {
        LinkedHashSet<InetAddress> localAddressList = RsNet.localAddressList(address -> address instanceof Inet4Address && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress());
        if (RsColl.isNotEmpty(localAddressList)) {
            return RsColl.getFirst(localAddressList);
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet4Address) {
                return localHost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }
}

