/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.StreamProgress;
import top.redscorpion.core.io.copy.StreamCopier;
import top.redscorpion.core.io.stream.FastByteArrayOutputStream;
import top.redscorpion.core.io.stream.StreamReader;
import top.redscorpion.core.io.stream.StreamWriter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsByte;
import top.redscorpion.core.util.RsNio;
import top.redscorpion.core.util.RsString;

public class RsIo
extends RsNio {
    public static long copy(InputStream in, OutputStream out) throws IORuntimeException {
        return RsIo.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IORuntimeException {
        return RsIo.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return RsIo.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        return new StreamCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    public static BufferedReader toReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static OutputStreamWriter toWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, Charset charset) throws IORuntimeException {
        return RsString.str(RsIo.readBytes(in), charset);
    }

    public static String read(Reader reader) throws IORuntimeException {
        return RsIo.read(reader, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String read(Reader reader, boolean isClose) throws IORuntimeException {
        StringBuilder builder = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
            if (!isClose) return builder.toString();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                RsIo.closeQuietly(reader);
                throw throwable;
            }
        }
        RsIo.closeQuietly(reader);
        return builder.toString();
    }

    public static byte[] readBytes(InputStream in) throws IORuntimeException {
        return RsIo.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws IORuntimeException {
        return StreamReader.of(in, isClose).readBytes();
    }

    public static <T> T readObj(InputStream in, Class<?> ... acceptClasses) throws IORuntimeException, RsException {
        return StreamReader.of(in, false).readObj(acceptClasses);
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return RsIo.toStream(RsByte.toBytes(content, charset));
    }

    public static InputStream toStream(File file) {
        Assert.notNull(file);
        return RsIo.toStream(file.toPath());
    }

    public static InputStream toStream(Path path) {
        Assert.notNull(path);
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static ByteArrayInputStream toStream(FastByteArrayOutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static BufferedReader toBuffered(Reader reader) {
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static InputStream toMarkSupport(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IORuntimeException {
        StreamWriter.of(out, isCloseOut).write(content);
    }

    public static void write(OutputStream out, Charset charset, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        StreamWriter.of(out, isCloseOut).writeStr(charset, contents);
    }

    public static void writeObjects(OutputStream out, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        StreamWriter.of(out, isCloseOut).writeObj(contents);
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (null == closeable) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String toStr(ByteArrayOutputStream out, Charset charset) {
        try {
            return out.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }
}

