/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import top.redscorpion.core.cache.SimpleCache;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.resource.MultiResource;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.spi.AbstractServiceLoader;
import top.redscorpion.core.spi.SPIException;
import top.redscorpion.core.util.RsClassLoader;
import top.redscorpion.core.util.RsResource;
import top.redscorpion.core.util.RsString;

public class ListServiceLoader<S>
extends AbstractServiceLoader<S> {
    private static final String PREFIX_SERVICES = "META-INF/services/";
    private final List<String> serviceNames = new ArrayList<String>();
    private final SimpleCache<String, S> serviceCache = new SimpleCache(new HashMap());

    public static <S> ListServiceLoader<S> of(Class<S> serviceClass, ClassLoader classLoader) {
        return ListServiceLoader.of(PREFIX_SERVICES, serviceClass, classLoader);
    }

    public static <S> ListServiceLoader<S> of(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader) {
        return new ListServiceLoader<S>(pathPrefix, serviceClass, classLoader, null);
    }

    public ListServiceLoader(String pathPrefix, Class<S> serviceClass, ClassLoader classLoader, Charset charset) {
        super(pathPrefix, serviceClass, classLoader, charset);
        this.load();
    }

    @Override
    public void load() {
        MultiResource resources = RsResource.getResources(this.pathPrefix + this.serviceClass.getName(), this.classLoader);
        for (Resource resource : resources) {
            this.parse(resource);
        }
    }

    @Override
    public int size() {
        return this.serviceNames.size();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            private final Iterator<String> nameIter;
            {
                this.nameIter = ListServiceLoader.this.serviceNames.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nameIter.hasNext();
            }

            @Override
            public S next() {
                return ListServiceLoader.this.getServiceByName(this.nameIter.next());
            }
        };
    }

    private void parse(Resource resource) {
        try (BufferedReader reader = resource.getReader(this.charset);){
            int lc = 1;
            while (lc >= 0) {
                lc = this.parseLine(resource, reader, lc);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private int parseLine(Resource resource, BufferedReader reader, int lineNo) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return -1;
        }
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        if ((line = RsString.trim(line)).length() > 0) {
            this.checkLine(resource, lineNo, line);
            List<String> names = this.serviceNames;
            if (!this.serviceCache.containsKey(line) && !names.contains(line)) {
                names.add(line);
            }
        }
        return lineNo + 1;
    }

    private void checkLine(Resource resource, int lineNo, String line) {
        int cp;
        if (RsString.containsBlank(line)) {
            this.fail(resource, lineNo, "Illegal configuration-file syntax");
        }
        if (!Character.isJavaIdentifierStart(cp = line.codePointAt(0))) {
            this.fail(resource, lineNo, "Illegal provider-class name: " + line);
        }
        int n = line.length();
        for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
            cp = line.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
            this.fail(resource, lineNo, "Illegal provider-class name: " + line);
        }
    }

    private void fail(Resource resource, int lineNo, String msg) {
        throw new SPIException(this.serviceClass + ":" + resource.getUrl() + ":" + lineNo + ": " + msg);
    }

    private S getServiceByName(String serviceClassName) {
        return (S)this.serviceCache.get(serviceClassName, () -> this.createService(serviceClassName));
    }

    private S createService(String serviceClassName) {
        return (S)RsConstructor.newInstance(RsClassLoader.loadClass(serviceClassName), new Object[0]);
    }
}

