/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.bean.copier.AbstractCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.bean.copier.ValueProvider;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsType;

public class ValueProviderToBeanCopier<T>
extends AbstractCopier<ValueProvider<String>, T> {
    private final Type targetType;

    public ValueProviderToBeanCopier(ValueProvider<String> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = RsBean.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        targetPropDescMap.forEach((tFieldName, tDesc) -> {
            if (null == tFieldName) {
                return;
            }
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = RsType.getActualType(this.targetType, tDesc.getFieldType());
            MutableEntry<String, Object> entry = this.copyOptions.editField((String)tFieldName, null);
            if (null == entry) {
                return;
            }
            tFieldName = entry.getKey();
            if (null == tFieldName) {
                return;
            }
            if (!((ValueProvider)this.source).containsKey(tFieldName)) {
                return;
            }
            Object sValue = ((ValueProvider)this.source).value(tFieldName, fieldType);
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), sValue)) {
                return;
            }
            tDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

