/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsConvert;

public class CopyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<?> editable;
    protected boolean ignoreNullValue;
    protected boolean ignoreError;
    protected boolean ignoreCase;
    private BiPredicate<Field, Object> propertiesFilter;
    protected UnaryOperator<MutableEntry<String, Object>> fieldEditor;
    protected boolean transientSupport = true;
    protected boolean override = true;
    protected Converter converter = (type, value) -> RsConvert.convertWithCheck(type, value, null, this.ignoreError);

    public static CopyOptions of() {
        return new CopyOptions();
    }

    public CopyOptions setIgnoreNullValue(boolean ignoreNullVall) {
        this.ignoreNullValue = ignoreNullVall;
        return this;
    }

    public CopyOptions setPropertiesFilter(BiPredicate<Field, Object> propertiesFilter) {
        this.propertiesFilter = propertiesFilter;
        return this;
    }

    public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
        return this.setPropertiesFilter((field, o) -> !RsArray.contains(ignoreProperties, field.getName()));
    }

    public CopyOptions setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public CopyOptions setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public CopyOptions setFieldEditor(UnaryOperator<MutableEntry<String, Object>> editor) {
        this.fieldEditor = editor;
        return this;
    }

    protected MutableEntry<String, Object> editField(String fieldName, Object fieldValue) {
        MutableEntry entry = new MutableEntry(fieldName, fieldValue);
        return null != this.fieldEditor ? (MutableEntry)this.fieldEditor.apply(entry) : entry;
    }

    protected Object convertField(Type targetType, Object fieldValue) {
        return null != this.converter ? this.converter.convert(targetType, fieldValue) : fieldValue;
    }

    protected boolean testPropertyFilter(Field field, Object value) {
        return null == this.propertiesFilter || this.propertiesFilter.test(field, value);
    }
}

