/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.useragent;

import top.redscorpion.core.util.RsString;
import top.redscorpion.http.useragent.Browser;
import top.redscorpion.http.useragent.BrowserEngine;
import top.redscorpion.http.useragent.OS;
import top.redscorpion.http.useragent.Platform;
import top.redscorpion.http.useragent.UserAgent;

public class UserAgentParser {
    public static UserAgent parse(String userAgentString) {
        if (RsString.isBlank(userAgentString)) {
            return null;
        }
        UserAgent userAgent = new UserAgent();
        Browser browser = UserAgentParser.parseBrowser(userAgentString);
        userAgent.setBrowser(browser);
        userAgent.setVersion(browser.getVersion(userAgentString));
        BrowserEngine engine = UserAgentParser.parseEngine(userAgentString);
        userAgent.setEngine(engine);
        userAgent.setEngineVersion(engine.getVersion(userAgentString));
        OS os = UserAgentParser.parseOS(userAgentString);
        userAgent.setOs(os);
        userAgent.setOsVersion(os.getVersion(userAgentString));
        Platform platform = UserAgentParser.parsePlatform(userAgentString);
        userAgent.setPlatform(platform);
        userAgent.setMobile(platform.isMobile() || browser.isMobile());
        return userAgent;
    }

    private static Browser parseBrowser(String userAgentString) {
        for (Browser browser : Browser.BROWERS) {
            if (!browser.isMatch(userAgentString)) continue;
            return browser;
        }
        return Browser.UNKNOWN;
    }

    private static BrowserEngine parseEngine(String userAgentString) {
        for (BrowserEngine engine : BrowserEngine.ENGINES) {
            if (!engine.isMatch(userAgentString)) continue;
            return engine;
        }
        return BrowserEngine.UNKNOWN;
    }

    private static OS parseOS(String userAgentString) {
        for (OS os : OS.OSES) {
            if (!os.isMatch(userAgentString)) continue;
            return os;
        }
        return OS.UNKNOWN;
    }

    private static Platform parsePlatform(String userAgentString) {
        for (Platform platform : Platform.PLATFORMS) {
            if (!platform.isMatch(userAgentString)) continue;
            return platform;
        }
        return Platform.UNKNOWN;
    }
}

