/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.meta;

import java.nio.charset.Charset;
import java.util.regex.Pattern;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.meta.ContentType;

public class RsContentType {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset\\s*=\\s*([a-z0-9-]*)", 2);

    public static Charset getCharset(String contentType) {
        return RsCharset.parse(RsContentType.getCharsetName(contentType), null);
    }

    public static String getCharsetName(String contentType) {
        if (RsString.isBlank(contentType)) {
            return null;
        }
        return RsRegular.get(CHARSET_PATTERN, (CharSequence)contentType, 1);
    }

    public static String getContentTypeByRequestBody(String body) {
        ContentType contentType = ContentType.get(body);
        return null == contentType ? null : contentType.toString();
    }
}

