/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.GlobalCompressStreamRegister;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.engine.jdk.JdkHttpResponse;

public class JdkHttpInputStream
extends InputStream {
    private InputStream in;

    public JdkHttpInputStream(JdkHttpResponse response) {
        this.init(response);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    private void init(JdkHttpResponse response) {
        block6: {
            try {
                this.in = response.status < 400 ? response.httpConnection.getInputStream() : response.httpConnection.getErrorStream();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block6;
                throw new HttpException(e);
            }
        }
        if (null == this.in) {
            this.in = new ByteArrayInputStream(RsString.format("Error request, null response with status: {}", response.status).getBytes());
            return;
        }
        String contentEncoding = response.contentEncoding();
        Class<? extends InputStream> streamClass = GlobalCompressStreamRegister.INSTANCE.get(contentEncoding);
        if (null != streamClass) {
            try {
                this.in = RsConstructor.newInstance(streamClass, this.in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

