/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine;

import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.util.RsSpi;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.log.RsLog;

public class ClientEngineFactory {
    public static ClientEngine getEngine() {
        return Singleton.get(ClientEngine.class.getName(), ClientEngineFactory::createEngine);
    }

    public static ClientEngine createEngine(ClientConfig config) {
        return ClientEngineFactory.createEngine().init(config);
    }

    public static ClientEngine createEngine() {
        ClientEngine engine = ClientEngineFactory.doCreateEngine();
        RsLog.debug("Use [{}] Http Engine As Default.", RsString.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static ClientEngine doCreateEngine() {
        ClientEngine engine = RsSpi.loadFirstAvailable(ClientEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new HttpException("No http jar found !Please add one of it to your project !");
    }
}

