/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.redscorpion.core.comparator.StringLengthComparator;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.mutable.MutableObj;
import top.redscorpion.core.regex.PatternPool;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsSet;
import top.redscorpion.core.util.RsString;

public class RsRegular {
    public static final Set<Character> RE_KEYS = RsSet.of(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    public static String get(String regex, CharSequence content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RsRegular.get(pattern, content, groupIndex);
    }

    public static String getGroup1(Pattern pattern, CharSequence content) {
        return RsRegular.get(pattern, content, 1);
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        MutableObj result = new MutableObj();
        RsRegular.get(pattern, content, matcher -> result.set(matcher.group(groupIndex)));
        return (String)result.get();
    }

    public static void get(Pattern pattern, CharSequence content, Consumer<Matcher> consumer) {
        if (null == content || null == pattern || null == consumer) {
            return;
        }
        Matcher m = pattern.matcher(content);
        if (m.find()) {
            consumer.accept(m);
        }
    }

    public static String delAll(String regex, CharSequence content) {
        if (RsString.hasEmpty(regex, content)) {
            return RsString.str(content);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RsRegular.delAll(pattern, content);
    }

    public static String delAll(Pattern pattern, CharSequence content) {
        if (null == pattern || RsString.isEmpty(content)) {
            return RsString.str(content);
        }
        return pattern.matcher(content).replaceAll("");
    }

    public static <T extends Collection<String>> T findAll(String regex, CharSequence content, int group, T collection) {
        if (null == regex) {
            return collection;
        }
        return RsRegular.findAll(PatternPool.get(regex, 32), content, group, collection);
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, CharSequence content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        Assert.notNull(collection, "Collection must be not null !", new Object[0]);
        RsRegular.findAll(pattern, content, matcher -> collection.add(matcher.group(group)));
        return collection;
    }

    public static void findAll(Pattern pattern, CharSequence content, Consumer<Matcher> consumer) {
        if (null == pattern || null == content) {
            return;
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            consumer.accept(matcher);
        }
    }

    public static boolean contains(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return false;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RsRegular.contains(pattern, content);
    }

    public static boolean contains(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).find();
    }

    public static Integer getFirstNumber(CharSequence stringWithNumber) {
        return RsConvert.toInt(RsRegular.get(PatternPool.NUMBERS, stringWithNumber, 0), null);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        if (RsString.isEmpty(content)) {
            return RsString.str(content);
        }
        Assert.notNull(replacementTemplate, "ReplacementTemplate must be not null !", new Object[0]);
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = RsRegular.findAll(PatternPool.GROUP_VAR, (CharSequence)replacementTemplate, 1, new TreeSet(StringLengthComparator.INSTANCE.reversed()));
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, RsRegular.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return RsString.str(content);
    }

    public static String escape(CharSequence content) {
        if (RsString.isBlank(content)) {
            return RsString.str(content);
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

