/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import top.redscorpion.core.collection.TransCollection;
import top.redscorpion.core.collection.iter.ArrayIter;
import top.redscorpion.core.convert.CompositeConverter;
import top.redscorpion.core.exception.RsExceptionHandle;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsCompare;
import top.redscorpion.core.util.RsIter;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsStream;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class RsColl {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !RsColl.isEmpty(collection);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return RsIter.join(iterable.iterator(), conjunction);
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        return RsColl.create(collectionType, null);
    }

    public static <T> Collection<T> create(Class<?> collectionType, Class<T> elementType) {
        Collection<Object> list;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet((o1, o2) -> {
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return RsCompare.compare(o1.toString(), o2.toString());
            });
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(Assert.notNull(elementType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)RsConstructor.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                Class<?> superclass = collectionType.getSuperclass();
                if (null != superclass && collectionType != superclass) {
                    return RsColl.create(superclass);
                }
                throw RsExceptionHandle.wrapRuntime(e);
            }
        }
        return list;
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> func) {
        return RsColl.map(collection, func, true);
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> mapper, boolean ignoreNull) {
        if (ignoreNull) {
            return RsStream.of(collection).filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return RsStream.of(collection).map(mapper).collect(Collectors.toList());
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            return RsColl.isEmpty(list) ? null : (T)list.get(0);
        }
        return RsIter.getFirst(RsIter.getIter(iterable));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Iterator<Object> iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (RsType.isUnknown((Type)elementType)) {
            elementType = Object.class;
        }
        if (value instanceof CharSequence) {
            String arrayStr = RsString.unWrap((CharSequence)value, '[', ']');
            iter = RsSplit.splitTrim(arrayStr, ",").iterator();
        } else {
            iter = value instanceof Map && RsBean.isWritableBean(RsType.getClass((Type)elementType)) ? new ArrayIter<Object>(new Object[]{value}) : RsIter.getIter(value);
        }
        CompositeConverter convert = CompositeConverter.getInstance();
        while (iter.hasNext()) {
            collection.add(convert.convert((Type)elementType, iter.next()));
        }
        return collection;
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size || index < 0) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        return RsIter.get(collection.iterator(), index);
    }

    public static <F, T> Collection<T> trans(Collection<F> collection, Function<? super F, ? extends T> function) {
        return new TransCollection<F, T>(collection, function);
    }
}

