/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import top.redscorpion.core.util.RsString;

public class RsCharset {
    public static final String NAME_UTF_8 = "UTF-8";
    public static final String NAME_GBK = "GBK";
    public static final Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    public static final Charset GBK;

    public static Charset charset(String charsetName) throws UnsupportedCharsetException {
        return RsString.isBlank(charsetName) ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public static Charset parse(String charsetName, Charset defaultCharset) {
        Charset result;
        if (RsString.isBlank(charsetName)) {
            return defaultCharset;
        }
        try {
            result = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            result = defaultCharset;
        }
        return result;
    }

    public static String convert(String source, Charset srcCharset, Charset destCharset) {
        if (null == srcCharset) {
            srcCharset = ISO_8859_1;
        }
        if (null == destCharset) {
            destCharset = UTF_8;
        }
        if (RsString.isBlank(source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(source.getBytes(srcCharset), destCharset);
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    static {
        Charset theGbk = null;
        try {
            theGbk = Charset.forName(NAME_GBK);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        GBK = theGbk;
    }
}

