/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.WeakConcurrentMap;
import top.redscorpion.core.reflect.lookup.RsLookup;
import top.redscorpion.core.reflect.method.RsMethodHandle;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsClassLoader;
import top.redscorpion.core.util.RsReflect;

public class RsConstructor {
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = RsConstructor.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!RsClass.isAllAssignableFrom(pts, parameterTypes)) continue;
            RsReflect.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, key -> RsConstructor.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static <T> T newInstance(String clazz) throws RsException {
        return RsConstructor.newInstance(RsClassLoader.loadClass(clazz), new Object[0]);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws RsException {
        Class<?>[] paramTypes = RsClass.getClasses(params);
        MethodHandle constructor = RsLookup.findConstructor(clazz, paramTypes);
        return RsMethodHandle.invokeHandle(constructor, params);
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        Assert.notNull(type);
        if (type.isPrimitive()) {
            return (T)RsClass.getPrimitiveDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            return (T)RsConstructor.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<Object>[] constructors;
            if (type.isEnum()) {
                return (T)type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<Object> constructor : constructors = RsConstructor.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                RsReflect.setAccessible(constructor);
                try {
                    return (T)constructor.newInstance(RsClass.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

