/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang;

import java.util.Objects;
import java.util.function.Function;
import top.redscorpion.core.func.SerSupplier;
import top.redscorpion.core.util.RsString;

public class Opt<T> {
    private static final Opt<?> EMPTY = new Opt<Object>(null);
    private final T value;
    private Throwable throwable;

    public static <T> Opt<T> empty() {
        Opt<?> t = EMPTY;
        return t;
    }

    public static <T> Opt<T> ofNullable(T value) {
        return value == null ? Opt.empty() : new Opt<T>(value);
    }

    public static <T> Opt<T> ofTry(SerSupplier<T> supplier) {
        try {
            return Opt.ofNullable(supplier.getting());
        }
        catch (Throwable e) {
            Opt<Object> empty = new Opt<Object>(null);
            empty.throwable = e;
            return empty;
        }
    }

    private Opt(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public <U> Opt<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofNullable(mapper.apply(this.value));
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opt)) {
            return false;
        }
        Opt other = (Opt)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return RsString.toStringOrNull(this.value);
    }
}

