/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.StreamProgress;
import top.redscorpion.core.io.stream.FastByteArrayOutputStream;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsString;

public class SyncInputStream
extends FilterInputStream {
    private final long length;
    private final boolean isIgnoreEOFError;
    private volatile boolean asyncFlag = true;

    public SyncInputStream(InputStream in, long length, boolean isAsync, boolean isIgnoreEofError) {
        super(in);
        this.length = length;
        this.isIgnoreEOFError = isIgnoreEofError;
        if (!isAsync) {
            this.sync();
        }
    }

    public SyncInputStream sync() {
        if (this.asyncFlag) {
            this.in = new ByteArrayInputStream(this.readBytes());
            this.asyncFlag = false;
        }
        return this;
    }

    public byte[] readBytes() {
        FastByteArrayOutputStream bytesOut = new FastByteArrayOutputStream(this.length > 0L ? (int)this.length : 1024);
        long length = this.copyTo(bytesOut, null);
        return length > 0L ? bytesOut.toByteArray() : new byte[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyTo(OutputStream out, StreamProgress streamProgress) {
        long copyLength = -1L;
        try {
            copyLength = RsIo.copy(this.in, out, 8192, this.length, streamProgress);
        }
        catch (IORuntimeException e) {
            block4: {
                try {
                    if (this.isIgnoreEOFError && SyncInputStream.isEOFException(e.getCause())) break block4;
                    throw e;
                }
                catch (Throwable throwable) {
                    RsIo.closeQuietly(this.in);
                    throw throwable;
                }
            }
            RsIo.closeQuietly(this.in);
        }
        RsIo.closeQuietly(this.in);
        return copyLength;
    }

    private static boolean isEOFException(Throwable e) {
        if (e instanceof FileNotFoundException) {
            return true;
        }
        return e instanceof EOFException || RsString.containsIgnoreCase(e.getMessage(), "Premature EOF");
    }
}

