/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.buffer;

public class FastByteBuffer {
    private byte[][] buffers = new byte[16][];
    private int buffersCount;
    private int currentBufferIndex = -1;
    private byte[] currentBuffer;
    private int offset;
    private int size;
    private final int minChunkLen;

    public FastByteBuffer(int size) {
        if (size <= 0) {
            size = 1024;
        }
        this.minChunkLen = Math.abs(size);
    }

    private void needNewBuffer(int newSize) {
        int delta = newSize - this.size;
        int newBufferSize = Math.max(this.minChunkLen, delta);
        ++this.currentBufferIndex;
        this.currentBuffer = new byte[newBufferSize];
        this.offset = 0;
        if (this.currentBufferIndex >= this.buffers.length) {
            int newLen = this.buffers.length << 1;
            byte[][] newBuffers = new byte[newLen][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        this.buffers[this.currentBufferIndex] = this.currentBuffer;
        ++this.buffersCount;
    }

    public FastByteBuffer append(byte[] array, int off, int len) {
        int part;
        int end = off + len;
        if (off < 0 || len < 0 || end > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newSize = this.size + len;
        int remaining = len;
        if (this.currentBuffer != null) {
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            remaining -= part;
            this.offset += part;
            this.size += part;
        }
        if (remaining > 0) {
            this.needNewBuffer(newSize);
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.size += part;
        }
        return this;
    }

    public FastByteBuffer append(byte element) {
        if (this.currentBuffer == null || this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.size + 1);
        }
        this.currentBuffer[this.offset] = element;
        ++this.offset;
        ++this.size;
        return this;
    }

    public byte[] toArray() {
        int pos = 0;
        byte[] array = new byte[this.size];
        if (this.currentBufferIndex == -1) {
            return array;
        }
        for (int i = 0; i < this.currentBufferIndex; ++i) {
            int len = this.buffers[i].length;
            System.arraycopy(this.buffers[i], 0, array, pos, len);
            pos += len;
        }
        System.arraycopy(this.buffers[this.currentBufferIndex], 0, array, pos, this.offset);
        return array;
    }

    public byte[] toArrayZeroCopyIfPossible() {
        int len;
        if (1 == this.currentBufferIndex && (len = this.buffers[0].length) == this.size) {
            return this.buffers[0];
        }
        return this.toArray();
    }
}

