/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.func;

import java.io.Serializable;
import java.util.function.Supplier;
import java.util.stream.Stream;
import top.redscorpion.core.exception.RsExceptionHandle;

@FunctionalInterface
public interface SerSupplier<R>
extends Supplier<R>,
Serializable {
    public R getting() throws Exception;

    @Override
    default public R get() {
        try {
            return this.getting();
        }
        catch (Exception e) {
            throw RsExceptionHandle.wrapRuntime(e);
        }
    }

    @SafeVarargs
    public static <T> SerSupplier<T> last(SerSupplier<T> ... serSups) {
        return Stream.of(serSups).reduce((l, r) -> r).orElseGet(() -> () -> null);
    }
}

