/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format.parser;

import top.redscorpion.core.date.DateException;
import top.redscorpion.core.date.DatePattern;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.format.DefaultDateBasic;
import top.redscorpion.core.date.format.parser.DateParser;
import top.redscorpion.core.util.RsString;

public class NormalDateParser
extends DefaultDateBasic
implements DateParser {
    private static final long serialVersionUID = 1L;
    public static NormalDateParser INSTANCE = new NormalDateParser();

    @Override
    public DateTime parse(String source) {
        int colonCount = RsString.count(source, ':');
        switch (colonCount) {
            case 0: {
                return new DateTime((CharSequence)source, DatePattern.NORM_DATE_FORMAT);
            }
            case 1: {
                return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
            }
            case 2: {
                int indexOfDot = RsString.indexOf((CharSequence)source, '.');
                if (indexOfDot > 0) {
                    int length1 = source.length();
                    if (length1 - indexOfDot > 4) {
                        source = RsString.subPre(source, indexOfDot + 4);
                    }
                    return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_MS_FORMAT);
                }
                return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", source);
    }
}

