/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format.parser;

import top.redscorpion.core.date.DateException;
import top.redscorpion.core.date.DatePattern;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.format.DefaultDateBasic;
import top.redscorpion.core.date.format.parser.DateParser;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;

public class ISO8601DateParser
extends DefaultDateBasic
implements DateParser {
    private static final long serialVersionUID = 1L;
    public static ISO8601DateParser INSTANCE = new ISO8601DateParser();

    @Override
    public DateTime parse(String source) {
        int length = source.length();
        if (RsString.contains((CharSequence)source, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return new DateTime((CharSequence)source, DatePattern.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength && length >= patternLength - 6) {
                return new DateTime((CharSequence)source, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (RsString.contains((CharSequence)source, '+')) {
                String zoneOffset = RsString.subAfter((CharSequence)(source = source.replace(" +", "+")), '+', true);
                if (RsString.isBlank(zoneOffset)) {
                    throw new DateException("Invalid format: [{}]", source);
                }
                if (!RsString.contains((CharSequence)zoneOffset, ':')) {
                    String pre = RsString.subBefore((CharSequence)source, '+', true);
                    source = pre + "+" + zoneOffset.substring(0, 2) + ":00";
                }
                if (RsString.contains((CharSequence)source, '.')) {
                    source = ISO8601DateParser.normalizeMillSeconds(source, ".", "+");
                    return new DateTime((CharSequence)source, DatePattern.ISO8601_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, DatePattern.ISO8601_WITH_XXX_OFFSET_FORMAT);
            }
            if (RsRegular.contains("-\\d{2}:?00", (CharSequence)source)) {
                if (':' != (source = source.replace(" -", "-")).charAt(source.length() - 3)) {
                    source = source.substring(0, source.length() - 2) + ":00";
                }
                if (RsString.contains((CharSequence)source, '.')) {
                    source = ISO8601DateParser.normalizeMillSeconds(source, ".", "-");
                    return new DateTime((CharSequence)source, DatePattern.ISO8601_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, DatePattern.ISO8601_WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return new DateTime((CharSequence)source, DatePattern.ISO8601_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 5) {
                return new DateTime((CharSequence)(source + ":00"), DatePattern.ISO8601_FORMAT);
            }
            if (RsString.contains((CharSequence)source, '.')) {
                source = ISO8601DateParser.normalizeMillSeconds(source, ".", null);
                return new DateTime((CharSequence)source, DatePattern.ISO8601_MS_FORMAT);
            }
        }
        throw new DateException("No UTC format fit for date String [{}] !", source);
    }

    private static String normalizeMillSeconds(String dateStr, CharSequence before, CharSequence after) {
        if (RsString.isBlank(after)) {
            String millOrNaco = RsString.subPre(RsString.subAfter((CharSequence)dateStr, before, true), 3);
            return RsString.subBefore((CharSequence)dateStr, before, true) + before + millOrNaco;
        }
        String millOrNaco = RsString.subPre(RsString.subBetween(dateStr, before, after), 3);
        return RsString.subBefore((CharSequence)dateStr, before, true) + before + millOrNaco + after + RsString.subAfter((CharSequence)dateStr, after, true);
    }
}

