/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.copier.ValueProvider;
import top.redscorpion.core.bean.copier.provider.BeanValueProvider;
import top.redscorpion.core.bean.copier.provider.MapValueProvider;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.kotlin.RsKotlinClass;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsType;

public class KBeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static KBeanConverter INSTANCE = new KBeanConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = RsType.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        ValueProvider valueProvider = null;
        if (value instanceof ValueProvider) {
            valueProvider = (ValueProvider)value;
        } else if (value instanceof Map) {
            valueProvider = new MapValueProvider((Map)value);
        } else if (RsBean.isWritableBean(value.getClass())) {
            valueProvider = new BeanValueProvider(value);
        }
        if (null != valueProvider) {
            return RsKotlinClass.newInstance(targetClass, valueProvider);
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

