/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.convert.RegisterConverter;
import top.redscorpion.core.convert.impl.ArrayConverter;
import top.redscorpion.core.convert.impl.BeanConverter;
import top.redscorpion.core.convert.impl.ClassConverter;
import top.redscorpion.core.convert.impl.CollectionConverter;
import top.redscorpion.core.convert.impl.DateConverter;
import top.redscorpion.core.convert.impl.EntryConverter;
import top.redscorpion.core.convert.impl.EnumConverter;
import top.redscorpion.core.convert.impl.KBeanConverter;
import top.redscorpion.core.convert.impl.MapConverter;
import top.redscorpion.core.convert.impl.NumberConverter;
import top.redscorpion.core.convert.impl.PrimitiveConverter;
import top.redscorpion.core.convert.impl.RecordConverter;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.reflect.kotlin.RsKotlinClass;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsRecord;
import top.redscorpion.core.util.RsType;

public class CompositeConverter
extends RegisterConverter {
    private static final long serialVersionUID = 1L;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Object convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    @Override
    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter converter;
        if (RsObject.isNull(value)) {
            return defaultValue;
        }
        if (RsType.isUnknown(type)) {
            if (null == defaultValue) {
                return (T)value;
            }
            type = defaultValue.getClass();
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(type, value, defaultValue);
        }
        if (type instanceof AbstractTypeReference) {
            type = ((AbstractTypeReference)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(type, value, defaultValue);
        }
        Class<?> rowType = RsType.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                throw new ConvertException("Can not get class from type: {}", type);
            }
        }
        if (null != (result = this.convertSpecial(type, rowType, value, defaultValue))) {
            return (T)result;
        }
        if (RsBean.isWritableBean(rowType)) {
            return (T)BeanConverter.INSTANCE.convert(type, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, type.getTypeName());
    }

    private <T> T convertSpecial(Type type, Class<T> rowType, Object value, T defaultValue) {
        if (null == rowType) {
            return null;
        }
        if (Date.class.isAssignableFrom(rowType)) {
            return DateConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (Collection.class.isAssignableFrom(rowType)) {
            return (T)CollectionConverter.INSTANCE.convert(type, value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(rowType)) {
            return (T)MapConverter.INSTANCE.convert(type, value, (Map)defaultValue);
        }
        if (Map.Entry.class.isAssignableFrom(rowType)) {
            return (T)EntryConverter.INSTANCE.convert(type, value);
        }
        if (rowType.isInstance(value)) {
            return (T)value;
        }
        if (rowType.isPrimitive()) {
            return PrimitiveConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (Number.class.isAssignableFrom(rowType)) {
            return NumberConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isEnum()) {
            return EnumConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isArray()) {
            return ArrayConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (RsRecord.isRecord(rowType)) {
            return (T)RecordConverter.INSTANCE.convert(type, value);
        }
        if (RsKotlinClass.isKotlinClass(rowType)) {
            return (T)KBeanConverter.INSTANCE.convert(type, value);
        }
        if ("java.lang.Class".equals(rowType.getName())) {
            return (T)ClassConverter.INSTANCE.convert(type, value);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

