/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsCast;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsType;

public abstract class AbstractConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (null == value) {
            return null;
        }
        if (RsType.isUnknown(targetType)) {
            throw new ConvertException("Unsupported convert to unKnown type: {}", targetType);
        }
        Class<?> targetClass = RsType.getClass(targetType);
        if (null == targetClass) {
            throw new ConvertException("Target type [{}] is not a class!", targetType);
        }
        if (targetClass.isInstance(value)) {
            return RsCast.castTo(targetClass, value);
        }
        return this.convertInternal(targetClass, value);
    }

    protected abstract Object convertInternal(Class<?> var1, Object var2);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (RsArray.isArray(value)) {
            return RsArray.toString(value);
        }
        if (RsChar.isChar(value)) {
            return RsChar.toString(((Character)value).charValue());
        }
        return value.toString();
    }
}

