/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import top.redscorpion.core.map.TableMap;
import top.redscorpion.core.util.RsAnnotation;
import top.redscorpion.core.util.RsSet;

public class CombinationAnnotationElement
implements AnnotatedElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = RsSet.of(Target.class, Retention.class, Inherited.class, Documented.class, SuppressWarnings.class, Override.class, Deprecated.class);
    private Map<Class<? extends Annotation>, Annotation> annotationMap;
    private Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap;
    private final Predicate<Annotation> predicate;

    public CombinationAnnotationElement(AnnotatedElement element) {
        this(element, null);
    }

    public CombinationAnnotationElement(AnnotatedElement element, Predicate<Annotation> predicate) {
        this.predicate = predicate;
        this.init(element);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotationMap.containsKey(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation = this.annotationMap.get(annotationClass);
        return (T)(annotation == null ? null : annotation);
    }

    @Override
    public Annotation[] getAnnotations() {
        Collection<Annotation> annotations = this.annotationMap.values();
        return annotations.toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Collection<Annotation> annotations = this.declaredAnnotationMap.values();
        return annotations.toArray(new Annotation[0]);
    }

    private void init(AnnotatedElement element) {
        Object[] declaredAnnotations = RsAnnotation.getDeclaredAnnotations(element);
        this.declaredAnnotationMap = new TableMap<Class<? extends Annotation>, Annotation>();
        this.parseDeclared((Annotation[])declaredAnnotations);
        Object[] annotations = element.getAnnotations();
        if (Arrays.equals(declaredAnnotations, annotations)) {
            this.annotationMap = this.declaredAnnotationMap;
        } else {
            this.annotationMap = new TableMap<Class<? extends Annotation>, Annotation>();
            this.parse((Annotation[])annotations);
        }
    }

    private void parseDeclared(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (META_ANNOTATIONS.contains(annotationType) || this.declaredAnnotationMap.containsKey(annotationType)) continue;
            if (this.test(annotation)) {
                this.declaredAnnotationMap.put(annotationType, annotation);
            }
            this.parseDeclared(RsAnnotation.getDeclaredAnnotations(annotationType));
        }
    }

    private void parse(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (META_ANNOTATIONS.contains(annotationType) || this.declaredAnnotationMap.containsKey(annotationType)) continue;
            if (this.test(annotation)) {
                this.annotationMap.put(annotationType, annotation);
            }
            this.parse(annotationType.getAnnotations());
        }
    }

    private boolean test(Annotation annotation) {
        return null == this.predicate || this.predicate.test(annotation);
    }
}

