/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.template.engine;

import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.util.RsReflect;
import top.redscorpion.core.util.RsServiceLoader;
import top.redscorpion.template.TemplateConfig;
import top.redscorpion.template.TemplateEngine;
import top.redscorpion.template.TemplateException;

public class TemplateFactory {
    private TemplateFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static TemplateEngine get() {
        return Singleton.get(TemplateEngine.class.getName(), TemplateFactory::create);
    }

    public static TemplateEngine create() {
        return TemplateFactory.create(new TemplateConfig());
    }

    public static TemplateEngine create(TemplateConfig config) {
        TemplateEngine engine = TemplateFactory.doCreate(config);
        return engine;
    }

    private static TemplateEngine doCreate(TemplateConfig config) {
        Class<? extends TemplateEngine> customEngineClass = config.getCustomEngine();
        TemplateEngine engine = null != customEngineClass ? RsReflect.newInstance(customEngineClass, new Object[0]) : RsServiceLoader.loadFirstAvailable(TemplateEngine.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new TemplateException("No template found ! Please add one of template jar to your project !");
    }
}

