/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersImpl;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.AbstractImageProvider;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.ImageProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import top.redscorpion.pdf.FooterSetting;
import top.redscorpion.pdf.HeaderSetting;
import top.redscorpion.pdf.PdfConvertException;
import top.redscorpion.pdf.PdfTemplateHandle;

public class RsPdf {
    public static void fileTo(String htmlPath, String pdfPath) {
        RsPdf.htmlTo(RsPdf.readHtmlFile(htmlPath), new File(pdfPath), new HeaderSetting(), new FooterSetting(), true);
    }

    public static void fileTo(String htmlPath, File file) {
        RsPdf.htmlTo(RsPdf.readHtmlFile(htmlPath), file, new HeaderSetting(), new FooterSetting(), true);
    }

    public static void fileTo(File htmlFile, String pdfPath) {
        RsPdf.htmlTo(RsPdf.readHtmlFile(htmlFile), new File(pdfPath), new HeaderSetting(), new FooterSetting(), true);
    }

    public static void fileTo(File htmlFile, File file) {
        RsPdf.htmlTo(RsPdf.readHtmlFile(htmlFile), file, new HeaderSetting(), new FooterSetting(), true);
    }

    public static void fileTo(String htmlPath, String filePath, HeaderSetting headerEntity, FooterSetting footerEntity) {
        RsPdf.htmlTo(RsPdf.readHtmlFile(htmlPath), new File(filePath), headerEntity, footerEntity, true);
    }

    public static void fileTo(String htmlPath, File file, HeaderSetting headerEntity, FooterSetting footerEntity) {
        RsPdf.htmlTo(RsPdf.readHtmlFile(htmlPath), file, headerEntity, footerEntity, true);
    }

    public static void htmlTo(String htmlStr, String filePath) {
        RsPdf.htmlTo(htmlStr, new File(filePath), new HeaderSetting(), new FooterSetting(), true);
    }

    public static void htmlTo(String htmlStr, File file) {
        RsPdf.htmlTo(htmlStr, file, new HeaderSetting(), new FooterSetting(), true);
    }

    public static void htmlTo(String htmlStr, String filePath, HeaderSetting headerEntity, FooterSetting footerEntity) {
        RsPdf.htmlTo(htmlStr, new File(filePath), headerEntity, footerEntity, true);
    }

    public static void htmlTo(String htmlStr, File file, HeaderSetting headerEntity, FooterSetting footerEntity) {
        RsPdf.htmlTo(htmlStr, file, headerEntity, footerEntity, true);
    }

    public static void htmlTo(String htmlStr, String filePath, HeaderSetting headerEntity, FooterSetting footerEntity, boolean isCover) {
        RsPdf.htmlTo(htmlStr, new File(filePath), headerEntity, footerEntity, isCover);
    }

    public static void htmlTo(String htmlStr, File file, HeaderSetting headerEntity, FooterSetting footerEntity, boolean isCover) {
        try {
            RsPdf.toPdf(htmlStr, file, headerEntity, footerEntity, isCover);
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:Pdf file generation failed.");
        }
        catch (DocumentException e) {
            throw new PdfConvertException("RS-PDF Error:Failed to define pdf file.");
        }
    }

    private static void toPdf(String htmlStr, File file, HeaderSetting headerEntity, FooterSetting footerEntity, boolean isCover) throws IOException, DocumentException {
        if (isCover) {
            if (file.exists()) {
                file.delete();
            }
        } else if (file.exists()) {
            throw new PdfConvertException("RS-PDF Error:This file already exists in the path.");
        }
        Document document = new Document(PageSize.A4, 25.0f, 25.0f, 32.0f, 40.0f);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
        PdfTemplateHandle header = new PdfTemplateHandle(8, PageSize.A4, headerEntity, footerEntity);
        writer.setPageEvent((PdfPageEvent)header);
        writer.addViewerPreference(PdfName.PRINTSCALING, (PdfObject)PdfName.NONE);
        document.open();
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver();
        CssAppliersImpl cssAppliers = new CssAppliersImpl((FontProvider)new XMLWorkerFontProvider(){

            public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color) {
                try {
                    BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
                    return new Font(bfChinese, size, style);
                }
                catch (Exception e) {
                    return super.getFont(fontname, encoding, size, style);
                }
            }
        });
        HtmlPipelineContext htmlContext = new HtmlPipelineContext((CssAppliers)cssAppliers);
        htmlContext.setTagFactory(Tags.getHtmlTagProcessorFactory());
        htmlContext.setImageProvider((ImageProvider)new AbstractImageProvider(){

            public Image retrieve(String src) {
                int pos = src.indexOf("base64,");
                try {
                    if (src.startsWith("data") && pos > 0) {
                        byte[] img = Base64.decode((String)src.substring(pos + 7));
                        return Image.getInstance((byte[])img);
                    }
                    if (src.startsWith("http")) {
                        return Image.getInstance((String)src);
                    }
                }
                catch (BadElementException ex) {
                    return null;
                }
                catch (IOException ex) {
                    return null;
                }
                return null;
            }

            public String getImageRootPath() {
                return null;
            }
        });
        PdfWriterPipeline pdf = new PdfWriterPipeline(document, writer);
        HtmlPipeline html = new HtmlPipeline(htmlContext, (Pipeline)pdf);
        CssResolverPipeline css = new CssResolverPipeline((CSSResolver)cssResolver, (Pipeline)html);
        XMLWorker worker = new XMLWorker((Pipeline)css, true);
        XMLParser p = new XMLParser((XMLParserListener)worker);
        p.parse((InputStream)new ByteArrayInputStream(htmlStr.getBytes()));
        document.close();
    }

    public static String readHtmlFile(String path) {
        File file = new File(path);
        return RsPdf.readHtmlFile(file);
    }

    public static String readHtmlFile(File file) {
        StringBuffer textHtml = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                textHtml.append(tempString);
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        return textHtml.toString();
    }
}

