/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.text.pdf.draw.LineSeparator;
import java.io.IOException;
import top.redscorpion.core.util.RsString;
import top.redscorpion.pdf.FooterSetting;
import top.redscorpion.pdf.HeaderSetting;

public class PdfTemplateHandle
extends PdfPageEventHelper {
    public HeaderSetting header;
    public FooterSetting footer;
    public int presentFontSize = 12;
    public Rectangle pageSize = PageSize.A4;
    public PdfTemplate total;
    public BaseFont bf = null;
    public Font fontDetail = null;
    private float totalX;

    public PdfTemplateHandle() {
    }

    public PdfTemplateHandle(int presentFontSize, Rectangle pageSize) {
        this.presentFontSize = presentFontSize;
        this.pageSize = pageSize;
    }

    public PdfTemplateHandle(int presentFontSize, Rectangle pageSize, HeaderSetting yeMei) {
        this.header = yeMei;
        this.presentFontSize = presentFontSize;
        this.pageSize = pageSize;
    }

    public PdfTemplateHandle(int presentFontSize, Rectangle pageSize, HeaderSetting yeMei, FooterSetting yeJiao) {
        this.presentFontSize = presentFontSize;
        this.pageSize = pageSize;
        this.header = yeMei;
        this.footer = yeJiao;
    }

    public void setHeader(HeaderSetting header) {
        this.header = header;
    }

    public void setFooter(FooterSetting footer) {
        this.footer = footer;
    }

    public void setPresentFontSize(int presentFontSize) {
        this.presentFontSize = presentFontSize;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(50.0f, 50.0f);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb;
        try {
            if (this.bf == null) {
                this.bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            if (this.fontDetail == null) {
                this.fontDetail = new Font(this.bf, (float)this.presentFontSize, 0);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int pageS = writer.getPageNumber();
        if (this.header != null && !this.header.getExcludePages().contains(pageS)) {
            cb = writer.getDirectContent();
            Paragraph p2 = new Paragraph();
            if (this.header.isLineTop() || this.header.isLineBottom()) {
                LineSeparator lineSeparator = new LineSeparator();
                lineSeparator.setLineColor(new BaseColor(90, 90, 90));
                lineSeparator.setLineWidth(0.8f);
                p2.add((Element)new Chunk((DrawInterface)lineSeparator));
            }
            if (this.header.isLineBottom()) {
                ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)p2, (float)0.0f, (float)document.top(), (float)0.0f);
            }
            if (RsString.isNotBlank(this.header.getTextLeft())) {
                ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)new Phrase(this.format(this.header.getTextLeft(), writer), this.fontDetail), (float)document.left(), (float)(document.top() + 6.0f), (float)0.0f);
            }
            if (RsString.isNotBlank(this.header.getTextCenter())) {
                ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Phrase(this.format(this.header.getTextCenter(), writer), this.fontDetail), (float)((document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f), (float)(document.top() + 6.0f), (float)0.0f);
            }
            if (RsString.isNotBlank(this.header.getTextRight())) {
                ColumnText.showTextAligned((PdfContentByte)cb, (int)2, (Phrase)new Phrase(this.format(this.header.getTextRight(), writer), this.fontDetail), (float)document.right(), (float)(document.top() + 6.0f), (float)0.0f);
            }
            if (this.header.isLineTop()) {
                ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)p2, (float)0.0f, (float)(document.top() + 18.0f), (float)0.0f);
            }
        }
        if (this.footer != null) {
            cb = writer.getDirectContent();
            float totalLen = 0.0f;
            if (RsString.isNotBlank(this.footer.getTotalText())) {
                totalLen = this.bf.getWidthPoint(this.footer.getTotalText(), (float)this.presentFontSize);
            }
            Paragraph p2 = new Paragraph();
            if (this.footer.isLineTop() || this.footer.isLineBottom()) {
                LineSeparator lineSeparator = new LineSeparator();
                lineSeparator.setLineColor(new BaseColor(90, 90, 90));
                lineSeparator.setLineWidth(0.8f);
                p2.add((Element)new Chunk((DrawInterface)lineSeparator));
            }
            if (this.footer.isLineTop()) {
                ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)p2, (float)0.0f, (float)(document.bottom() - 8.0f), (float)0.0f);
            }
            if (RsString.isNotBlank(this.footer.getTextLeft())) {
                if (RsString.isNotBlank(this.footer.getTotalText()) && "left".equals(this.footer.getTotalAlign()) && "left".equals(this.footer.getTotalLeftOrRight())) {
                    this.totalX = document.left();
                    ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)new Phrase(this.format(this.footer.getTextLeft(), writer), this.fontDetail), (float)(document.left() + totalLen / 2.0f), (float)(document.bottom() - 20.0f), (float)0.0f);
                } else {
                    if (RsString.isNotBlank(this.footer.getTotalText()) && "left".equals(this.footer.getTotalAlign()) && "right".equals(this.footer.getTotalLeftOrRight())) {
                        this.totalX = document.left() + this.bf.getWidthPoint(this.footer.getTextLeft(), (float)this.presentFontSize);
                    }
                    ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)new Phrase(this.format(this.footer.getTextLeft(), writer), this.fontDetail), (float)document.left(), (float)(document.bottom() - 20.0f), (float)0.0f);
                }
            }
            if (RsString.isNotBlank(this.footer.getTextCenter())) {
                float centerLen = this.bf.getWidthPoint(this.footer.getTextCenter(), (float)this.presentFontSize);
                if (RsString.isNotBlank(this.footer.getTotalText()) && "center".equals(this.footer.getTotalAlign())) {
                    if ("left".equals(this.footer.getTotalLeftOrRight())) {
                        this.totalX = (document.rightMargin() + document.right() + document.leftMargin() - document.left() - centerLen) / 2.0f - totalLen / 4.0f;
                        ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Phrase(this.format(this.footer.getTextCenter(), writer), this.fontDetail), (float)((document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f + totalLen / 4.0f), (float)(document.bottom() - 20.0f), (float)0.0f);
                    } else if ("right".equals(this.footer.getTotalLeftOrRight())) {
                        this.totalX = (document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f + centerLen / 2.0f - totalLen / 4.0f;
                        ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Phrase(this.format(this.footer.getTextCenter(), writer), this.fontDetail), (float)((document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f - totalLen / 4.0f), (float)(document.bottom() - 20.0f), (float)0.0f);
                    }
                } else {
                    ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Phrase(this.format(this.footer.getTextCenter(), writer), this.fontDetail), (float)((document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f), (float)(document.bottom() - 20.0f), (float)0.0f);
                }
            }
            if (RsString.isNotBlank(this.footer.getTextRight())) {
                if (RsString.isNotBlank(this.footer.getTotalText()) && "right".equals(this.footer.getTotalAlign()) && "right".equals(this.footer.getTotalLeftOrRight())) {
                    this.totalX = document.right() - totalLen / 2.0f;
                    ColumnText.showTextAligned((PdfContentByte)cb, (int)2, (Phrase)new Phrase(this.format(this.footer.getTextRight(), writer), this.fontDetail), (float)(document.right() - totalLen / 2.0f), (float)(document.bottom() - 20.0f), (float)0.0f);
                } else {
                    if (RsString.isNotBlank(this.footer.getTotalText()) && "right".equals(this.footer.getTotalAlign()) && "left".equals(this.footer.getTotalLeftOrRight())) {
                        this.totalX = document.right() - this.bf.getWidthPoint(this.footer.getTextRight(), (float)this.presentFontSize);
                    }
                    ColumnText.showTextAligned((PdfContentByte)cb, (int)2, (Phrase)new Phrase(this.format(this.footer.getTextRight(), writer), this.fontDetail), (float)document.right(), (float)(document.bottom() - 20.0f), (float)0.0f);
                }
            }
            if (this.footer.isLineBottom()) {
                ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)p2, (float)0.0f, (float)(document.bottom() - 26.0f), (float)0.0f);
            }
            if (RsString.isNotBlank(this.footer.getTotalText())) {
                cb.addTemplate(this.total, this.totalX, document.bottom() - 20.0f);
            }
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        if (this.footer != null && RsString.isNotBlank(this.footer.getTotalText())) {
            this.total.beginText();
            this.total.setFontAndSize(this.bf, (float)this.presentFontSize);
            this.total.showText(this.format(this.footer.getTotalText(), writer));
            this.total.endText();
            this.total.closePath();
        }
    }

    private String format(String str, PdfWriter writer) {
        String newStr = str;
        if (newStr.indexOf("${page}") > 0) {
            newStr = newStr.replace("${page}", String.valueOf(writer.getPageNumber()));
        }
        if (newStr.indexOf("${total}") > 0) {
            newStr = newStr.replace("${total}", String.valueOf(writer.getPageNumber() - 1));
        }
        return newStr;
    }
}

