/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.log.dialect.console;

import java.util.LinkedHashMap;
import top.redscorpion.core.date.DateUtil;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Console;
import top.redscorpion.core.util.RsString;
import top.redscorpion.log.AbstractLog;
import top.redscorpion.log.level.Level;

public class ConsoleLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String LOG_FORMAT = "[{date}] [{level}] {name}: {msg}";
    private static Level currentLevel = Level.DEBUG;
    private final String name;

    public ConsoleLog(Class<?> clazz) {
        this.name = null == clazz ? "null" : clazz.getName();
    }

    public ConsoleLog(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void setLevel(Level customLevel) {
        Assert.notNull(customLevel);
        currentLevel = customLevel;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.TRACE, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.DEBUG, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.WARN, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Object ... arguments) {
        this.log(fqcn, Level.ERROR, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("date", DateUtil.now());
        map.put("level", level.toString());
        map.put("name", this.name);
        map.put("msg", RsString.format(format, arguments));
        String logMsg = RsString.format((CharSequence)LOG_FORMAT, map);
        if (level.ordinal() >= Level.WARN.ordinal()) {
            Console.error(t, logMsg, new Object[0]);
        } else {
            Console.log(t, logMsg, new Object[0]);
        }
    }

    @Override
    public boolean isEnabled(Level level) {
        return currentLevel.compareTo(level) <= 0;
    }
}

