/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.log.dialect.console;

import java.util.function.Function;
import top.redscorpion.core.date.DateUtil;
import top.redscorpion.core.lang.ansi.AnsiColor;
import top.redscorpion.core.lang.ansi.AnsiEncoder;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsString;
import top.redscorpion.log.dialect.console.ConsoleLog;
import top.redscorpion.log.level.Level;

public class ConsoleColorLog
extends ConsoleLog {
    private static final AnsiColor COLOR_CLASSNAME = AnsiColor.CYAN;
    private static final AnsiColor COLOR_TIME = AnsiColor.WHITE;
    private static final AnsiColor COLOR_NONE = AnsiColor.DEFAULT;
    private static Function<Level, AnsiColor> colorFactory = level -> {
        switch (level) {
            case DEBUG: 
            case INFO: {
                return AnsiColor.GREEN;
            }
            case WARN: {
                return AnsiColor.YELLOW;
            }
            case ERROR: {
                return AnsiColor.RED;
            }
            case TRACE: {
                return AnsiColor.MAGENTA;
            }
        }
        return COLOR_NONE;
    };

    public static void setColorFactory(Function<Level, AnsiColor> colorFactory) {
        ConsoleColorLog.colorFactory = colorFactory;
    }

    public ConsoleColorLog(String name) {
        super(name);
    }

    public ConsoleColorLog(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public synchronized void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        String template = AnsiEncoder.encode(COLOR_TIME, "[%s]", colorFactory.apply(level), "[%-5s]%s", COLOR_CLASSNAME, "%-30s: ", COLOR_NONE, "%s%n");
        System.out.format(template, DateUtil.now(), level.name(), " - ", RsClass.getShortClassName(this.getName()), RsString.format(format, arguments));
    }
}

