/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.log;

import java.util.Map;
import top.redscorpion.core.lang.caller.CallerUtil;
import top.redscorpion.core.map.SafeConcurrentHashMap;
import top.redscorpion.core.util.RsServiceLoader;
import top.redscorpion.log.GlobalLogFactory;
import top.redscorpion.log.Log;
import top.redscorpion.log.dialect.console.ConsoleLogFactory;

public abstract class LogFactory {
    protected String name;
    private final Map<Object, Log> logCache;

    public LogFactory(String name) {
        this.name = name;
        this.logCache = new SafeConcurrentHashMap<Object, Log>();
    }

    public String getName() {
        return this.name;
    }

    public Log getLog(String name) {
        return this.logCache.computeIfAbsent(name, o -> this.createLog((String)o));
    }

    public Log getLog(Class<?> clazz) {
        return this.logCache.computeIfAbsent(clazz, o -> this.createLog((Class)o));
    }

    public abstract Log createLog(String var1);

    public abstract Log createLog(Class<?> var1);

    protected void checkLogExist(Class<?> logClassName) {
    }

    public static LogFactory getCurrentLogFactory() {
        return GlobalLogFactory.get();
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        return GlobalLogFactory.set(logFactoryClass);
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        return GlobalLogFactory.set(logFactory);
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(CallerUtil.getCallerCaller());
    }

    public static LogFactory create() {
        LogFactory factory = LogFactory.doCreate();
        factory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", factory.name);
        return factory;
    }

    private static LogFactory doCreate() {
        LogFactory factory = RsServiceLoader.loadFirstAvailable(LogFactory.class);
        if (null != factory) {
            return factory;
        }
        return new ConsoleLogFactory();
    }
}

